/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import java.util.Date;
import java.util.Optional;
import org.activiti.api.process.model.ProcessInstance;
import org.activiti.api.process.model.events.ProcessRuntimeEvent;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.process.model.events.CloudProcessStartedEvent;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandler;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.activiti.cloud.services.query.model.QueryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessStartedEventHandler
implements QueryEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessStartedEventHandler.class);
    private final EntityManager entityManager;

    public ProcessStartedEventHandler(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void handle(CloudRuntimeEvent<?, ?> event) {
        CloudProcessStartedEvent startedEvent = (CloudProcessStartedEvent)event;
        String processInstanceId = ((ProcessInstance)startedEvent.getEntity()).getId();
        LOGGER.debug("Handling start of process Instance " + processInstanceId);
        Optional<ProcessInstanceEntity> findResult = Optional.ofNullable((ProcessInstanceEntity)this.entityManager.find(ProcessInstanceEntity.class, (Object)processInstanceId));
        ProcessInstanceEntity processInstanceEntity = findResult.orElseThrow(() -> new QueryException("Unable to find process instance with the given id: " + processInstanceId));
        if (ProcessInstance.ProcessInstanceStatus.CREATED.equals((Object)processInstanceEntity.getStatus())) {
            processInstanceEntity.setStatus(ProcessInstance.ProcessInstanceStatus.RUNNING);
            processInstanceEntity.setName(((ProcessInstance)startedEvent.getEntity()).getName());
            processInstanceEntity.setLastModified(new Date(startedEvent.getTimestamp()));
            processInstanceEntity.setStartDate(((ProcessInstance)startedEvent.getEntity()).getStartDate());
            processInstanceEntity.setLinkedProcessInstanceId(startedEvent.getLinkedProcessInstanceId());
            processInstanceEntity.setLinkedProcessInstanceType(startedEvent.getLinkedProcessInstanceType());
            this.entityManager.persist((Object)processInstanceEntity);
        }
    }

    @Override
    public String getHandledEvent() {
        return ProcessRuntimeEvent.ProcessEvents.PROCESS_STARTED.name();
    }
}

