/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import java.util.Optional;
import org.activiti.api.process.model.ProcessCandidateStarterGroup;
import org.activiti.api.process.model.events.ProcessCandidateStarterGroupEvent;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.process.model.events.CloudProcessCandidateStarterGroupRemovedEvent;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandler;
import org.activiti.cloud.services.query.model.ProcessCandidateStarterGroupEntity;
import org.activiti.cloud.services.query.model.ProcessCandidateStarterGroupId;
import org.activiti.cloud.services.query.model.QueryException;

public class ProcessCandidateStarterGroupRemovedEventHandler
implements QueryEventHandler {
    private final EntityManager entityManager;

    public ProcessCandidateStarterGroupRemovedEventHandler(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void handle(CloudRuntimeEvent<?, ?> event) {
        CloudProcessCandidateStarterGroupRemovedEvent processCandidateStarterGroupRemovedEvent = (CloudProcessCandidateStarterGroupRemovedEvent)event;
        ProcessCandidateStarterGroup processCandidateStarterGroup = (ProcessCandidateStarterGroup)processCandidateStarterGroupRemovedEvent.getEntity();
        ProcessCandidateStarterGroupId id = new ProcessCandidateStarterGroupId(processCandidateStarterGroup.getProcessDefinitionId(), processCandidateStarterGroup.getGroupId());
        try {
            Optional.ofNullable((ProcessCandidateStarterGroupEntity)this.entityManager.find(ProcessCandidateStarterGroupEntity.class, (Object)id)).ifPresent(arg_0 -> ((EntityManager)this.entityManager).remove(arg_0));
        }
        catch (Exception cause) {
            throw new QueryException("Error handling ProcessCandidateStarterGroupRemovedEvent[" + String.valueOf(event) + "]", (Throwable)cause);
        }
    }

    @Override
    public String getHandledEvent() {
        return ProcessCandidateStarterGroupEvent.ProcessCandidateStarterGroupEvents.PROCESS_CANDIDATE_STARTER_GROUP_REMOVED.name();
    }
}

