/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import org.activiti.api.process.model.BPMNActivity;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.process.model.events.CloudBPMNActivityEvent;
import org.activiti.cloud.services.query.model.BPMNActivityEntity;
import org.activiti.cloud.services.query.model.BaseBPMNActivityEntity;
import org.activiti.cloud.services.query.model.ServiceTaskEntity;

public abstract class BaseBPMNActivityEventHandler {
    protected final EntityManager entityManager;

    public BaseBPMNActivityEventHandler(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    protected BaseBPMNActivityEntity findOrCreateBPMNActivityEntity(CloudRuntimeEvent<?, ?> event) {
        CloudBPMNActivityEvent activityEvent = (CloudBPMNActivityEvent)CloudBPMNActivityEvent.class.cast(event);
        BPMNActivity bpmnActivity = (BPMNActivity)activityEvent.getEntity();
        String pkId = BPMNActivityEntity.IdBuilderHelper.from((BPMNActivity)bpmnActivity);
        BaseBPMNActivityEntity bpmnActivityEntity = null;
        bpmnActivityEntity = "serviceTask".equals(bpmnActivity.getActivityType()) ? (BaseBPMNActivityEntity)this.entityManager.find(ServiceTaskEntity.class, (Object)pkId) : (BaseBPMNActivityEntity)this.entityManager.find(BPMNActivityEntity.class, (Object)pkId);
        if (bpmnActivityEntity == null) {
            bpmnActivityEntity = this.createBpmnActivityEntity(event);
        }
        return bpmnActivityEntity;
    }

    public BaseBPMNActivityEntity createBpmnActivityEntity(CloudRuntimeEvent<?, ?> event) {
        CloudBPMNActivityEvent activityEvent = (CloudBPMNActivityEvent)CloudBPMNActivityEvent.class.cast(event);
        BPMNActivity bpmnActivity = (BPMNActivity)activityEvent.getEntity();
        String pkId = BPMNActivityEntity.IdBuilderHelper.from((BPMNActivity)bpmnActivity);
        Object bpmnActivityEntity = "serviceTask".equals(bpmnActivity.getActivityType()) ? new ServiceTaskEntity(event.getServiceName(), event.getServiceFullName(), event.getServiceVersion(), event.getAppName(), event.getAppVersion()) : new BPMNActivityEntity(event.getServiceName(), event.getServiceFullName(), event.getServiceVersion(), event.getAppName(), event.getAppVersion());
        bpmnActivityEntity.setId(pkId);
        bpmnActivityEntity.setElementId(bpmnActivity.getElementId());
        bpmnActivityEntity.setActivityName(bpmnActivity.getActivityName());
        bpmnActivityEntity.setActivityType(bpmnActivity.getActivityType());
        bpmnActivityEntity.setProcessDefinitionId(bpmnActivity.getProcessDefinitionId());
        bpmnActivityEntity.setProcessInstanceId(bpmnActivity.getProcessInstanceId());
        bpmnActivityEntity.setExecutionId(bpmnActivity.getExecutionId());
        bpmnActivityEntity.setProcessDefinitionKey(activityEvent.getProcessDefinitionKey());
        bpmnActivityEntity.setProcessDefinitionVersion(activityEvent.getProcessDefinitionVersion());
        bpmnActivityEntity.setBusinessKey(activityEvent.getBusinessKey());
        return bpmnActivityEntity;
    }
}

