/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import java.util.Optional;
import org.activiti.api.process.model.IntegrationContext;
import org.activiti.cloud.api.process.model.events.CloudIntegrationEvent;
import org.activiti.cloud.services.query.model.IntegrationContextEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseIntegrationEventHandler {
    private static final Logger logger = LoggerFactory.getLogger(BaseIntegrationEventHandler.class);
    protected final EntityManager entityManager;

    public BaseIntegrationEventHandler(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    protected Optional<IntegrationContextEntity> findIntegrationContextEntity(CloudIntegrationEvent event) {
        IntegrationContext integrationContext = (IntegrationContext)event.getEntity();
        String pkId = IntegrationContextEntity.IdBuilderHelper.from((IntegrationContext)integrationContext);
        IntegrationContextEntity entity = (IntegrationContextEntity)this.entityManager.find(IntegrationContextEntity.class, (Object)pkId);
        return Optional.ofNullable(entity);
    }
}

