/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import java.util.Date;
import java.util.Optional;
import org.activiti.api.process.model.ProcessInstance;
import org.activiti.api.process.model.events.ProcessRuntimeEvent;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.process.model.events.CloudProcessCreatedEvent;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandler;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessCreatedEventHandler
implements QueryEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessCreatedEventHandler.class);
    private EntityManager entityManager;

    public ProcessCreatedEventHandler(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void handle(CloudRuntimeEvent<?, ?> event) {
        CloudProcessCreatedEvent createdEvent = (CloudProcessCreatedEvent)event;
        String processInstanceId = ((ProcessInstance)createdEvent.getEntity()).getId();
        LOGGER.debug("Handling created process Instance " + ((ProcessInstance)createdEvent.getEntity()).getId());
        Optional.ofNullable((ProcessInstanceEntity)this.entityManager.find(ProcessInstanceEntity.class, (Object)processInstanceId)).ifPresentOrElse(processInstance -> LOGGER.warn("Process instance entity already exists for: " + processInstanceId + "!"), () -> {
            ProcessInstanceEntity createdProcessInstanceEntity = this.createProcessInstanceEntity(createdEvent);
            this.entityManager.persist((Object)createdProcessInstanceEntity);
        });
    }

    private ProcessInstanceEntity createProcessInstanceEntity(CloudProcessCreatedEvent createdEvent) {
        ProcessInstanceEntity createdProcessInstanceEntity = new ProcessInstanceEntity();
        createdProcessInstanceEntity.setServiceName(createdEvent.getServiceName());
        createdProcessInstanceEntity.setServiceFullName(createdEvent.getServiceFullName());
        createdProcessInstanceEntity.setServiceVersion(createdEvent.getServiceVersion());
        createdProcessInstanceEntity.setAppName(createdEvent.getAppName());
        createdProcessInstanceEntity.setAppVersion(createdEvent.getAppVersion());
        createdProcessInstanceEntity.setProcessDefinitionId(((ProcessInstance)createdEvent.getEntity()).getProcessDefinitionId());
        createdProcessInstanceEntity.setId(((ProcessInstance)createdEvent.getEntity()).getId());
        createdProcessInstanceEntity.setStatus(ProcessInstance.ProcessInstanceStatus.CREATED);
        createdProcessInstanceEntity.setLastModified(new Date(createdEvent.getTimestamp()));
        createdProcessInstanceEntity.setName(((ProcessInstance)createdEvent.getEntity()).getName());
        createdProcessInstanceEntity.setProcessDefinitionKey(((ProcessInstance)createdEvent.getEntity()).getProcessDefinitionKey());
        createdProcessInstanceEntity.setInitiator(((ProcessInstance)createdEvent.getEntity()).getInitiator());
        createdProcessInstanceEntity.setBusinessKey(((ProcessInstance)createdEvent.getEntity()).getBusinessKey());
        createdProcessInstanceEntity.setStartDate(((ProcessInstance)createdEvent.getEntity()).getStartDate());
        createdProcessInstanceEntity.setParentId(((ProcessInstance)createdEvent.getEntity()).getParentId());
        createdProcessInstanceEntity.setProcessDefinitionVersion(((ProcessInstance)createdEvent.getEntity()).getProcessDefinitionVersion());
        createdProcessInstanceEntity.setProcessDefinitionName(((ProcessInstance)createdEvent.getEntity()).getProcessDefinitionName());
        createdProcessInstanceEntity.setRootProcessInstanceId(((ProcessInstance)createdEvent.getEntity()).getRootProcessInstanceId());
        return createdProcessInstanceEntity;
    }

    @Override
    public String getHandledEvent() {
        return ProcessRuntimeEvent.ProcessEvents.PROCESS_CREATED.name();
    }
}

