/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.app;

import jakarta.persistence.EntityManager;
import java.util.List;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandlerContext;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandlerContextOptimizer;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Transactional(propagation=Propagation.REQUIRES_NEW)
public class QueryConsumerChannelHandler {
    private final QueryEventHandlerContext eventHandlerContext;
    private final QueryEventHandlerContextOptimizer optimizer;
    private final EntityManager entityManager;

    public QueryConsumerChannelHandler(QueryEventHandlerContext eventHandlerContext, QueryEventHandlerContextOptimizer optimizer, EntityManager entityManager) {
        this.optimizer = optimizer;
        this.eventHandlerContext = eventHandlerContext;
        this.entityManager = entityManager;
    }

    public synchronized void receive(List<CloudRuntimeEvent<?, ?>> events) {
        QueryConsumerChannelHandler.afterCompletion(() -> ((EntityManager)this.entityManager).clear());
        this.eventHandlerContext.handle(this.optimizer.optimize(events).toArray(new CloudRuntimeEvent[0]));
    }

    private static void afterCompletion(final Runnable action) {
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCompletion(int status) {
                action.run();
            }
        });
    }
}

