/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import java.util.Date;
import java.util.Optional;
import org.activiti.api.process.model.ProcessInstance;
import org.activiti.api.process.model.events.ProcessRuntimeEvent;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.process.model.events.CloudProcessSuspendedEvent;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandler;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.activiti.cloud.services.query.model.QueryException;

public class ProcessSuspendedEventHandler
implements QueryEventHandler {
    private final EntityManager entityManager;

    public ProcessSuspendedEventHandler(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void handle(CloudRuntimeEvent<?, ?> event) {
        CloudProcessSuspendedEvent suspendedEvent = (CloudProcessSuspendedEvent)event;
        String processInstanceId = ((ProcessInstance)suspendedEvent.getEntity()).getId();
        ProcessInstanceEntity processInstanceEntity = Optional.ofNullable((ProcessInstanceEntity)this.entityManager.find(ProcessInstanceEntity.class, (Object)processInstanceId)).orElseThrow(() -> new QueryException("Unable to find process instance with the given id: " + processInstanceId));
        processInstanceEntity.setStatus(ProcessInstance.ProcessInstanceStatus.SUSPENDED);
        processInstanceEntity.setLastModified(new Date(suspendedEvent.getTimestamp()));
        processInstanceEntity.setSuspendedDate(new Date(suspendedEvent.getTimestamp()));
        this.entityManager.persist((Object)processInstanceEntity);
    }

    @Override
    public String getHandledEvent() {
        return ProcessRuntimeEvent.ProcessEvents.PROCESS_SUSPENDED.name();
    }
}

