/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.notifications.graphql.jpa.query;

import graphql.Internal;
import graphql.com.google.common.collect.ImmutableList;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputFieldsContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.visibility.GraphqlFieldVisibility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

public class VisibleFields
implements GraphqlFieldVisibility {
    private final List<Pattern> patterns;

    @Internal
    private VisibleFields(List<Pattern> patterns) {
        this.patterns = patterns;
    }

    public List<GraphQLFieldDefinition> getFieldDefinitions(GraphQLFieldsContainer fieldsContainer) {
        return (List)fieldsContainer.getFieldDefinitions().stream().filter(fieldDefinition -> !this.block(this.mkFQN(fieldsContainer.getName(), fieldDefinition.getName()))).collect(ImmutableList.toImmutableList());
    }

    public GraphQLFieldDefinition getFieldDefinition(GraphQLFieldsContainer fieldsContainer, String fieldName) {
        GraphQLFieldDefinition fieldDefinition = fieldsContainer.getFieldDefinition(fieldName);
        if (fieldDefinition != null && this.block(this.mkFQN(fieldsContainer.getName(), fieldDefinition.getName()))) {
            fieldDefinition = null;
        }
        return fieldDefinition;
    }

    public List<GraphQLInputObjectField> getFieldDefinitions(GraphQLInputFieldsContainer fieldsContainer) {
        return (List)fieldsContainer.getFieldDefinitions().stream().filter(fieldDefinition -> !this.block(this.mkFQN(fieldsContainer.getName(), fieldDefinition.getName()))).collect(ImmutableList.toImmutableList());
    }

    public GraphQLInputObjectField getFieldDefinition(GraphQLInputFieldsContainer fieldsContainer, String fieldName) {
        GraphQLInputObjectField fieldDefinition = fieldsContainer.getFieldDefinition(fieldName);
        if (fieldDefinition != null && this.block(this.mkFQN(fieldsContainer.getName(), fieldDefinition.getName()))) {
            fieldDefinition = null;
        }
        return fieldDefinition;
    }

    private boolean block(String fqn) {
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(fqn).matches()) continue;
            return false;
        }
        return true;
    }

    private String mkFQN(String containerName, String fieldName) {
        return containerName + "." + fieldName;
    }

    public static Builder newFieldsVisibility() {
        return new Builder();
    }

    public static class Builder {
        private final List<Pattern> patterns = new ArrayList<Pattern>();

        public Builder addPattern(String regexPattern) {
            return this.addCompiledPattern(Pattern.compile(regexPattern));
        }

        public Builder addPatterns(Collection<String> regexPatterns) {
            regexPatterns.forEach(this::addPattern);
            return this;
        }

        public Builder addCompiledPattern(Pattern regex) {
            this.patterns.add(regex);
            return this;
        }

        public Builder addCompiledPatterns(Collection<Pattern> regexes) {
            regexes.forEach(this::addCompiledPattern);
            return this;
        }

        public GraphqlFieldVisibility build() {
            return new VisibleFields(this.patterns);
        }
    }
}

