/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.notifications.graphql.events.consumer;

import java.util.List;
import java.util.Map;
import org.activiti.cloud.services.notifications.graphql.events.model.EngineEvent;
import org.activiti.cloud.services.notifications.graphql.events.transformer.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;

public class EngineEventsConsumerMessageHandler {
    private static Logger logger = LoggerFactory.getLogger(EngineEventsConsumerMessageHandler.class);
    private final Transformer transformer;

    public EngineEventsConsumerMessageHandler(Transformer transformer) {
        this.transformer = transformer;
    }

    @org.springframework.integration.annotation.Transformer
    public Message<List<EngineEvent>> receive(Message<List<Map<String, Object>>> message) {
        List events = (List)message.getPayload();
        String routingKey = (String)message.getHeaders().get((Object)"routingKey");
        logger.debug("Received message with routingKey: {}", (Object)routingKey);
        return MessageBuilder.createMessage(this.transformer.transform(events), (MessageHeaders)message.getHeaders());
    }
}

