/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.notifications.graphql.events;

import java.lang.annotation.Annotation;
import org.activiti.cloud.services.notifications.graphql.events.RoutingKeyResolver;
import org.activiti.cloud.services.notifications.graphql.events.SpELTemplateRoutingKey;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class SpELTemplateRoutingKeyResolver
implements RoutingKeyResolver {
    private ExpressionParser parser = new SpelExpressionParser();
    private ParserContext parserContext = new TemplateParserContext();

    @Override
    public String resolveRoutingKey(Object object) {
        Annotation annotation = AnnotationUtils.findAnnotation(object.getClass(), SpELTemplateRoutingKey.class);
        if (annotation == null) {
            throw new RuntimeException("Cannot resolve routing key for class: " + String.valueOf(object.getClass()));
        }
        String value = AnnotationUtils.getValue((Annotation)annotation).toString();
        Expression expression = this.parser.parseExpression(value, this.parserContext);
        return expression.getValue(object).toString();
    }
}

