/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.notifications.graphql.web.api;

import jakarta.validation.constraints.NotNull;
import java.util.Collections;
import java.util.Map;

public class GraphQLQueryRequest {
    @NotNull
    private String query;
    private Map<String, Object> variables;

    private GraphQLQueryRequest(Builder builder) {
        this.query = builder.query;
        this.variables = builder.variables;
    }

    GraphQLQueryRequest() {
    }

    public String getQuery() {
        return this.query;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public static IQueryStage builder() {
        return new Builder();
    }

    public static final class Builder
    implements IQueryStage,
    IBuildStage {
        private String query;
        private Map<String, Object> variables = Collections.emptyMap();

        private Builder() {
        }

        @Override
        public IBuildStage withQuery(String query) {
            this.query = query;
            return this;
        }

        @Override
        public IBuildStage withVariables(Map<String, Object> variables) {
            this.variables = variables;
            return this;
        }

        @Override
        public GraphQLQueryRequest build() {
            return new GraphQLQueryRequest(this);
        }
    }

    public static interface IBuildStage {
        public IBuildStage withVariables(Map<String, Object> var1);

        public GraphQLQueryRequest build();
    }

    public static interface IQueryStage {
        public IBuildStage withQuery(String var1);
    }
}

