/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.messages.events.producer;

import org.activiti.api.process.model.MessageSubscription;
import org.activiti.api.process.model.builders.MessageEventPayloadBuilder;
import org.activiti.api.process.model.events.MessageSubscriptionCancelledEvent;
import org.activiti.api.process.model.payloads.MessageEventPayload;
import org.activiti.api.process.runtime.events.listener.ProcessRuntimeEventListener;
import org.activiti.cloud.services.messages.events.support.MessageEventsDispatcher;
import org.activiti.cloud.services.messages.events.support.MessageSubscriptionEventMessageBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.messaging.Message;

public class MessageSubscriptionCancelledEventMessageProducer
implements ProcessRuntimeEventListener<MessageSubscriptionCancelledEvent> {
    private static final Logger logger = LoggerFactory.getLogger(MessageSubscriptionCancelledEventMessageProducer.class);
    private final MessageSubscriptionEventMessageBuilderFactory messageBuilderFactory;
    private final MessageEventsDispatcher messageEventsDispatcher;

    public MessageSubscriptionCancelledEventMessageProducer(@NonNull MessageEventsDispatcher messageEventsDispatcher, @NonNull MessageSubscriptionEventMessageBuilderFactory messageBuilderFactory) {
        this.messageEventsDispatcher = messageEventsDispatcher;
        this.messageBuilderFactory = messageBuilderFactory;
    }

    public void onEvent(@NonNull MessageSubscriptionCancelledEvent event) {
        logger.debug("onEvent: {}", (Object)event);
        MessageSubscription messageSubscription = (MessageSubscription)event.getEntity();
        MessageEventPayload messageEventPayload = MessageEventPayloadBuilder.messageEvent((String)messageSubscription.getEventName()).withCorrelationKey(messageSubscription.getConfiguration()).build();
        Message message = this.messageBuilderFactory.create((MessageSubscription)event.getEntity()).withPayload((Object)messageEventPayload).setHeader("messageEventType", (Object)event.getEventType().name()).build();
        this.messageEventsDispatcher.dispatch(message);
    }
}

