/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.messages.events.support;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.integration.MessageDispatchingException;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.transaction.support.TransactionSynchronization;

public class MessageSenderTransactionSynchronization
implements TransactionSynchronization {
    private static final Logger logger = LoggerFactory.getLogger(MessageSenderTransactionSynchronization.class);
    private final Message<?> message;
    private final MessageChannel messageChannel;

    public MessageSenderTransactionSynchronization(Message<?> message, MessageChannel messageChannel) {
        this.message = message;
        this.messageChannel = messageChannel;
    }

    public void afterCommit() {
        logger.debug("Sending bpmn message '{}' via message channel: {}", this.message, (Object)this.messageChannel);
        try {
            boolean sent = this.messageChannel.send(this.message);
            if (!sent) {
                throw new MessageDispatchingException(this.message);
            }
        }
        catch (Exception cause) {
            logger.error("Sending bpmn message {} failed due to error: {}", this.message, (Object)cause.getMessage());
        }
    }
}

