/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.messages.events.support;

import org.activiti.cloud.services.messages.events.support.MessageSenderTransactionSynchronization;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class MessageEventsDispatcher {
    private final MessageChannel messageEvents;
    private final BindingServiceProperties bindingServiceProperties;

    public MessageEventsDispatcher(MessageChannel messageEvents, BindingServiceProperties bindingServiceProperties) {
        this.messageEvents = messageEvents;
        this.bindingServiceProperties = bindingServiceProperties;
    }

    public void dispatch(Message<?> message) {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("requires active transaction synchronization");
        }
        String messageEventOutputDestination = this.bindingServiceProperties.getBindingDestination("commandConsumer");
        Message dispatchMessage = MessageBuilder.fromMessage(message).setHeader("messageEventOutputDestination", (Object)messageEventOutputDestination).build();
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new MessageSenderTransactionSynchronization(dispatchMessage, this.messageEvents));
    }
}

