/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.job.executor;

import java.util.Date;
import org.activiti.cloud.services.job.executor.JobMessageProducer;
import org.activiti.engine.impl.asyncexecutor.DefaultJobManager;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.runtime.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;

public class MessageBasedJobManager
extends DefaultJobManager {
    private static final Logger logger = LoggerFactory.getLogger(MessageBasedJobManager.class);
    private final BindingServiceProperties bindingServiceProperties;
    private final JobMessageProducer jobMessageProducer;
    private String inputChannelName = "asyncExecutorJobsInput";
    private String outputChannelName = "asyncExecutorJobsOutput";

    public MessageBasedJobManager(ProcessEngineConfigurationImpl processEngineConfiguration, BindingServiceProperties bindingServiceProperties, JobMessageProducer jobMessageProducer) {
        super(processEngineConfiguration);
        this.bindingServiceProperties = bindingServiceProperties;
        this.jobMessageProducer = jobMessageProducer;
    }

    protected void triggerExecutorIfNeeded(JobEntity jobEntity) {
        logger.debug("triggerExecutorIfNeeded for job: {}", (Object)jobEntity);
        this.sendMessage((Job)jobEntity);
    }

    public void unacquire(Job job) {
        logger.debug("unacquire job: {}", (Object)job);
        if (job instanceof JobEntity) {
            JobEntity jobEntity = (JobEntity)job;
            jobEntity.setLockExpirationTime(new Date(this.processEngineConfiguration.getClock().getCurrentTime().getTime() + (long)this.processEngineConfiguration.getAsyncExecutor().getAsyncJobLockTimeInMillis()));
        }
        this.sendMessage(job);
    }

    public BindingProperties getBindingProperties() {
        return this.bindingServiceProperties.getBindingProperties("asyncExecutorJobsInput");
    }

    public String getOutputChannelName() {
        return this.outputChannelName;
    }

    public String getInputChannelName() {
        return this.inputChannelName;
    }

    public void sendMessage(Job job) {
        logger.debug("sendMessage for job: {}", (Object)job);
        this.jobMessageProducer.sendMessage(this.getOutputChannelName(), job);
    }
}

