/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.job.executor;

import org.activiti.cloud.common.messaging.config.FunctionBindingConfiguration;
import org.activiti.cloud.services.job.executor.JobMessageBuilderFactory;
import org.activiti.cloud.services.job.executor.JobMessageFailedEvent;
import org.activiti.cloud.services.job.executor.JobMessageProducer;
import org.activiti.cloud.services.job.executor.JobMessageSentEvent;
import org.activiti.engine.runtime.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.integration.MessageDispatchingException;
import org.springframework.lang.NonNull;
import org.springframework.messaging.Message;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class DefaultJobMessageProducer
implements JobMessageProducer {
    private static final Logger logger = LoggerFactory.getLogger(DefaultJobMessageProducer.class);
    private static final String ROUTING_KEY = "routingKey";
    private final StreamBridge streamBridge;
    private final ApplicationEventPublisher eventPublisher;
    private final JobMessageBuilderFactory jobMessageBuilderFactory;
    private final FunctionBindingConfiguration.BindingResolver bindingResolver;

    public DefaultJobMessageProducer(StreamBridge streamBridge, ApplicationEventPublisher eventPublisher, JobMessageBuilderFactory jobMessageBuilderFactory, FunctionBindingConfiguration.BindingResolver bindingResolver) {
        this.streamBridge = streamBridge;
        this.eventPublisher = eventPublisher;
        this.jobMessageBuilderFactory = jobMessageBuilderFactory;
        this.bindingResolver = bindingResolver;
    }

    @Override
    public void sendMessage(@NonNull String bindingName, @NonNull Job job) {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("requires active transaction synchronization");
        }
        Assert.hasLength((String)job.getId(), (String)"job id must not be empty");
        Assert.hasLength((String)bindingName, (String)"job binding name must not be empty");
        Message message = this.jobMessageBuilderFactory.create(job).withPayload((Object)job.getId()).setHeader(ROUTING_KEY, (Object)bindingName).setHeader("spring.cloud.function.destination", (Object)this.bindingResolver.getBindingDestination(bindingName)).build();
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new JobMessageTransactionSynchronization((Message<String>)message, bindingName));
    }

    class JobMessageTransactionSynchronization
    implements TransactionSynchronization {
        private final String bindingName;
        private final Message<String> message;

        public JobMessageTransactionSynchronization(Message<String> message, String bindingName) {
            this.bindingName = bindingName;
            this.message = message;
        }

        public void afterCommit() {
            logger.debug("Sending job message '{}' via stream bridge to: {}", this.message, (Object)this.bindingName);
            try {
                boolean sent = DefaultJobMessageProducer.this.streamBridge.send(this.bindingName, this.message);
                if (!sent) {
                    throw new MessageDispatchingException(this.message);
                }
                DefaultJobMessageProducer.this.eventPublisher.publishEvent((ApplicationEvent)new JobMessageSentEvent(this.message, this.bindingName));
            }
            catch (Exception cause) {
                logger.error("Sending job message {} failed due to error: {}", this.message, (Object)cause.getMessage());
                DefaultJobMessageProducer.this.eventPublisher.publishEvent((ApplicationEvent)new JobMessageFailedEvent(this.message, cause, this.bindingName));
            }
        }
    }
}

