/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.job.executor;

import org.activiti.cloud.services.job.executor.MessageBasedJobManager;
import org.activiti.cloud.services.job.executor.MessageBasedJobManagerFactory;
import org.activiti.engine.cfg.ProcessEngineConfigurator;
import org.activiti.engine.impl.asyncexecutor.JobManager;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.SmartLifecycle;

public class MessageBasedJobManagerConfigurator
implements ProcessEngineConfigurator,
SmartLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(MessageBasedJobManagerConfigurator.class);
    private static final String MESSAGE_BASED_JOB_MANAGER = "messageBasedJobManager";
    private final MessageBasedJobManagerFactory messageBasedJobManagerFactory;
    private final ConfigurableListableBeanFactory beanFactory;
    private ProcessEngineConfigurationImpl configuration;
    private boolean running = false;

    public MessageBasedJobManagerConfigurator(ConfigurableListableBeanFactory beanFactory, MessageBasedJobManagerFactory messageBasedJobManagerFactory) {
        this.messageBasedJobManagerFactory = messageBasedJobManagerFactory;
        this.beanFactory = beanFactory;
    }

    protected MessageBasedJobManager createMessageBasedJobManager(ProcessEngineConfigurationImpl configuration) {
        MessageBasedJobManager instance = this.messageBasedJobManagerFactory.create(configuration);
        return this.registerBean(MESSAGE_BASED_JOB_MANAGER, instance);
    }

    public void beforeInit(ProcessEngineConfigurationImpl configuration) {
        MessageBasedJobManager messageBasedJobManager = this.createMessageBasedJobManager(configuration);
        configuration.setAsyncExecutorActivate(false);
        configuration.setAsyncExecutorMessageQueueMode(true);
        configuration.setJobManager((JobManager)messageBasedJobManager);
        logger.info("Configured message based job manager class: {}", ((Object)((Object)messageBasedJobManager)).getClass());
    }

    public void configure(ProcessEngineConfigurationImpl configuration) {
        this.configuration = configuration;
    }

    public int getPriority() {
        return 0;
    }

    public void start() {
        if (!this.configuration.getAsyncExecutor().isActive()) {
            this.configuration.getAsyncExecutor().start();
        }
        this.running = true;
    }

    public void stop() {
        try {
            if (this.configuration.getAsyncExecutor().isActive()) {
                this.configuration.getAsyncExecutor().shutdown();
            }
        }
        finally {
            this.running = false;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    protected <T> T registerBean(String name, T bean) {
        this.beanFactory.registerSingleton(name, bean);
        return (T)this.beanFactory.initializeBean(bean, name);
    }
}

