/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.events.services;

import org.activiti.api.process.model.IntegrationContext;
import org.activiti.cloud.services.events.converter.RuntimeBundleInfoAppender;
import org.activiti.cloud.services.events.message.MessageBuilderChainFactory;
import org.activiti.cloud.services.events.services.CreateIncidentEventCmd;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.impl.context.ExecutionContext;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.springframework.messaging.Message;

class CreateIncidentEventFromIntegrationCmd
extends CreateIncidentEventCmd {
    private final IntegrationContext integrationContext;
    private final Exception exception;
    private final RuntimeService runtimeService;

    CreateIncidentEventFromIntegrationCmd(IntegrationContext integrationContext, Exception exception, RuntimeService runtimeService, MessageBuilderChainFactory<ExecutionContext> messageBuilderIncidentsChainFactory, RuntimeBundleInfoAppender runtimeBundleInfoAppender) {
        super(messageBuilderIncidentsChainFactory, runtimeBundleInfoAppender);
        this.integrationContext = integrationContext;
        this.exception = exception;
        this.runtimeService = runtimeService;
    }

    public Message execute(CommandContext commandContext) {
        String executionId = this.integrationContext.getExecutionId();
        ExecutionEntity execution = this.getExecutionEntity(executionId);
        return this.createMessage(new ExecutionContext(execution), this.exception);
    }

    private ExecutionEntity getExecutionEntity(String executionId) {
        return (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(executionId).list().getFirst();
    }
}

