/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.events.converter;

import java.util.Optional;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.model.shared.impl.events.CloudRuntimeEventImpl;
import org.activiti.engine.impl.context.ExecutionContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.repository.ProcessDefinition;

public class ExecutionContextInfoAppender {
    private final ExecutionContext executionContext;

    public ExecutionContextInfoAppender(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public CloudRuntimeEvent<?, ?> appendExecutionContextInfoTo(CloudRuntimeEventImpl<?, ?> event) {
        if (this.executionContext != null) {
            ExecutionEntity processInstance = this.executionContext.getProcessInstance();
            ProcessDefinition processDefinition = this.executionContext.getProcessDefinition();
            if (processInstance != null) {
                event.setProcessInstanceId(processInstance.getId());
                event.setBusinessKey(processInstance.getBusinessKey());
                if (processInstance.getSuperExecutionId() != null) {
                    Optional.ofNullable(processInstance.getSuperExecution()).ifPresent(superExecution -> event.setParentProcessInstanceId(superExecution.getProcessInstanceId()));
                }
            }
            if (processDefinition != null) {
                event.setProcessDefinitionId(processDefinition.getId());
                event.setProcessDefinitionKey(processDefinition.getKey());
                event.setProcessDefinitionVersion(Integer.valueOf(processDefinition.getVersion()));
            }
        }
        return event;
    }
}

