/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.events.listeners;

import java.util.Optional;
import org.activiti.api.model.shared.model.VariableInstance;
import org.activiti.api.process.model.BPMNActivity;
import org.activiti.api.process.model.BPMNError;
import org.activiti.api.process.model.BPMNMessage;
import org.activiti.api.process.model.BPMNSequenceFlow;
import org.activiti.api.process.model.BPMNSignal;
import org.activiti.api.process.model.BPMNTimer;
import org.activiti.api.process.model.IntegrationContext;
import org.activiti.api.process.model.MessageSubscription;
import org.activiti.api.task.model.Task;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.model.shared.events.CloudVariableEvent;
import org.activiti.cloud.api.model.shared.impl.events.CloudRuntimeEventImpl;
import org.activiti.cloud.api.process.model.events.CloudBPMNActivityEvent;
import org.activiti.cloud.api.process.model.events.CloudBPMNErrorReceivedEvent;
import org.activiti.cloud.api.process.model.events.CloudBPMNMessageEvent;
import org.activiti.cloud.api.process.model.events.CloudBPMNSignalEvent;
import org.activiti.cloud.api.process.model.events.CloudBPMNTimerEvent;
import org.activiti.cloud.api.process.model.events.CloudIntegrationEvent;
import org.activiti.cloud.api.process.model.events.CloudMessageSubscriptionCancelledEvent;
import org.activiti.cloud.api.process.model.events.CloudProcessRuntimeEvent;
import org.activiti.cloud.api.process.model.events.CloudSequenceFlowEvent;
import org.activiti.cloud.api.task.model.events.CloudTaskCandidateGroupEvent;
import org.activiti.cloud.api.task.model.events.CloudTaskCandidateUserEvent;
import org.activiti.cloud.api.task.model.events.CloudTaskRuntimeEvent;
import org.activiti.cloud.services.events.converter.CachingExecutionContext;
import org.activiti.cloud.services.events.converter.ExecutionContextInfoAppender;
import org.activiti.cloud.services.events.listeners.BaseCommandContextEventsAggregator;
import org.activiti.cloud.services.events.listeners.MessageProducerCommandContextCloseListener;
import org.activiti.engine.impl.context.ExecutionContext;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;

public class ProcessEngineEventsAggregator
extends BaseCommandContextEventsAggregator<CloudRuntimeEvent<?, ?>, MessageProducerCommandContextCloseListener> {
    private final MessageProducerCommandContextCloseListener closeListener;

    public ProcessEngineEventsAggregator(MessageProducerCommandContextCloseListener closeListener) {
        this.closeListener = closeListener;
    }

    @Override
    protected Class<MessageProducerCommandContextCloseListener> getCloseListenerClass() {
        return MessageProducerCommandContextCloseListener.class;
    }

    @Override
    protected MessageProducerCommandContextCloseListener getCloseListener() {
        return this.closeListener;
    }

    @Override
    protected String getAttributeKey() {
        return "processEngineEvents";
    }

    @Override
    public void add(CloudRuntimeEvent<?, ?> element) {
        String executionId;
        CommandContext commandContext = this.getCurrentCommandContext();
        ExecutionContext executionContext = this.resolveExecutionContext(commandContext, executionId = this.resolveExecutionId(element));
        if (executionContext != null) {
            ExecutionContextInfoAppender executionContextInfoAppender = this.createExecutionContextInfoAppender(executionContext);
            CloudRuntimeEventImpl event = (CloudRuntimeEventImpl)CloudRuntimeEventImpl.class.cast(element);
            element = executionContextInfoAppender.appendExecutionContextInfoTo(event);
        }
        super.add(element);
    }

    protected ExecutionContext resolveExecutionContext(CommandContext commandContext, String executionId) {
        if (executionId != null && commandContext.getGenericAttribute(executionId) == null) {
            Optional.ofNullable((ExecutionEntity)commandContext.getExecutionEntityManager().findById(executionId)).ifPresent(executionEntity -> {
                this.mayBeAddRootExecutionContext(commandContext, (ExecutionEntity)executionEntity);
                ExecutionContext executionContext = this.createExecutionContext((ExecutionEntity)executionEntity);
                commandContext.addAttribute(executionId, (Object)executionContext);
            });
        }
        return (ExecutionContext)commandContext.getGenericAttribute(executionId);
    }

    protected void mayBeAddRootExecutionContext(CommandContext commandContext, ExecutionEntity executionEntity) {
        ExecutionContext rootExecutionContext = (ExecutionContext)commandContext.getGenericAttribute("rootExecutionContext");
        if (rootExecutionContext == null && executionEntity.getRootProcessInstanceId() != null) {
            ExecutionEntity rootProcessInstance = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(executionEntity.getRootProcessInstanceId());
            rootExecutionContext = this.createExecutionContext(rootProcessInstance);
            commandContext.addAttribute("rootExecutionContext", (Object)rootExecutionContext);
        }
    }

    protected ExecutionContextInfoAppender createExecutionContextInfoAppender(ExecutionContext executionContext) {
        return new ExecutionContextInfoAppender(executionContext);
    }

    protected ExecutionContext createExecutionContext(ExecutionEntity executionEntity) {
        return new CachingExecutionContext(executionEntity);
    }

    protected String resolveExecutionId(CloudRuntimeEvent<?, ?> element) {
        if (element instanceof CloudProcessRuntimeEvent) {
            return element.getEntityId();
        }
        if (element instanceof CloudVariableEvent) {
            return ((VariableInstance)element.getEntity()).getProcessInstanceId();
        }
        if (element instanceof CloudTaskRuntimeEvent) {
            return ((Task)element.getEntity()).getProcessInstanceId();
        }
        if (element instanceof CloudBPMNActivityEvent) {
            return ((BPMNActivity)element.getEntity()).getProcessInstanceId();
        }
        if (element instanceof CloudSequenceFlowEvent) {
            return ((BPMNSequenceFlow)element.getEntity()).getProcessInstanceId();
        }
        if (element instanceof CloudIntegrationEvent) {
            return ((IntegrationContext)((CloudIntegrationEvent)element).getEntity()).getProcessInstanceId();
        }
        if (element instanceof CloudTaskCandidateUserEvent) {
            return ((CloudTaskCandidateUserEvent)element).getProcessInstanceId();
        }
        if (element instanceof CloudTaskCandidateGroupEvent) {
            return ((CloudTaskCandidateGroupEvent)element).getProcessInstanceId();
        }
        if (element instanceof CloudBPMNSignalEvent) {
            return ((BPMNSignal)((CloudBPMNSignalEvent)element).getEntity()).getProcessInstanceId();
        }
        if (element instanceof CloudBPMNTimerEvent) {
            return ((BPMNTimer)((CloudBPMNTimerEvent)element).getEntity()).getProcessInstanceId();
        }
        if (element instanceof CloudBPMNMessageEvent) {
            return ((BPMNMessage)((CloudBPMNMessageEvent)element).getEntity()).getProcessInstanceId();
        }
        if (element instanceof CloudBPMNErrorReceivedEvent) {
            return ((BPMNError)((CloudBPMNErrorReceivedEvent)element).getEntity()).getProcessInstanceId();
        }
        if (element instanceof CloudMessageSubscriptionCancelledEvent) {
            return ((MessageSubscription)((CloudMessageSubscriptionCancelledEvent)element).getEntity()).getProcessInstanceId();
        }
        if (element instanceof CloudIntegrationEvent) {
            return ((IntegrationContext)((CloudIntegrationEvent)element).getEntity()).getProcessInstanceId();
        }
        return null;
    }
}

