/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.events.converter;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.activiti.api.model.shared.event.VariableCreatedEvent;
import org.activiti.api.model.shared.event.VariableDeletedEvent;
import org.activiti.api.model.shared.event.VariableUpdatedEvent;
import org.activiti.api.model.shared.model.VariableInstance;
import org.activiti.cloud.api.model.shared.events.CloudVariableCreatedEvent;
import org.activiti.cloud.api.model.shared.events.CloudVariableDeletedEvent;
import org.activiti.cloud.api.model.shared.events.CloudVariableUpdatedEvent;
import org.activiti.cloud.api.model.shared.impl.events.CloudRuntimeEventImpl;
import org.activiti.cloud.api.model.shared.impl.events.CloudVariableCreatedEventImpl;
import org.activiti.cloud.api.model.shared.impl.events.CloudVariableDeletedEventImpl;
import org.activiti.cloud.api.model.shared.impl.events.CloudVariableUpdatedEventImpl;
import org.activiti.cloud.services.events.converter.RuntimeBundleInfoAppender;
import org.activiti.core.common.model.connector.VariableDefinition;
import org.activiti.spring.process.ProcessExtensionService;
import org.activiti.spring.process.model.Extension;

public class ToCloudVariableEventConverter {
    private final RuntimeBundleInfoAppender runtimeBundleInfoAppender;
    private final ProcessExtensionService processExtensionService;

    public ToCloudVariableEventConverter(RuntimeBundleInfoAppender runtimeBundleInfoAppender, ProcessExtensionService processExtensionService) {
        this.runtimeBundleInfoAppender = runtimeBundleInfoAppender;
        this.processExtensionService = processExtensionService;
    }

    public CloudVariableCreatedEvent from(VariableCreatedEvent event) {
        CloudVariableCreatedEventImpl cloudEvent = new CloudVariableCreatedEventImpl((VariableInstance)event.getEntity(), event.isEphemeralVariable());
        this.runtimeBundleInfoAppender.appendRuntimeBundleInfoTo((CloudRuntimeEventImpl<?, ?>)cloudEvent);
        cloudEvent.setVariableDefinitionId(this.getVariableDefinitionId(event));
        return cloudEvent;
    }

    public CloudVariableUpdatedEvent from(VariableUpdatedEvent event) {
        CloudVariableUpdatedEventImpl cloudEvent = new CloudVariableUpdatedEventImpl((VariableInstance)event.getEntity(), event.getPreviousValue(), event.isEphemeralVariable());
        this.runtimeBundleInfoAppender.appendRuntimeBundleInfoTo((CloudRuntimeEventImpl<?, ?>)cloudEvent);
        return cloudEvent;
    }

    public CloudVariableDeletedEvent from(VariableDeletedEvent event) {
        CloudVariableDeletedEventImpl cloudEvent = new CloudVariableDeletedEventImpl((VariableInstance)event.getEntity(), event.isEphemeralVariable());
        this.runtimeBundleInfoAppender.appendRuntimeBundleInfoTo((CloudRuntimeEventImpl<?, ?>)cloudEvent);
        return cloudEvent;
    }

    private String getVariableDefinitionId(VariableCreatedEvent event) {
        return Optional.ofNullable(event.getProcessDefinitionId()).map(arg_0 -> ((ProcessExtensionService)this.processExtensionService).getExtensionsForId(arg_0)).map(Extension::getProperties).map(Map::values).stream().flatMap(Collection::stream).filter(variableDefinition -> variableDefinition.getName() != null).filter(variableDefinition -> variableDefinition.getName().equals(((VariableInstance)event.getEntity()).getName())).map(VariableDefinition::getId).findFirst().orElse(null);
    }
}

