/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.alfresco.converter.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import org.activiti.cloud.alfresco.converter.json.PagedModelConverter;
import org.activiti.cloud.alfresco.rest.model.EntryResponseContent;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.json.MappingJacksonValue;
import org.springframework.lang.Nullable;

public class AlfrescoJackson2HttpMessageConverter<T>
extends MappingJackson2HttpMessageConverter {
    private final PagedModelConverter pagedCollectionModelConverter;
    private final ObjectMapper objectMapper;

    public AlfrescoJackson2HttpMessageConverter(PagedModelConverter pagedCollectionModelConverter, ObjectMapper objectMapper) {
        super(objectMapper);
        this.pagedCollectionModelConverter = pagedCollectionModelConverter;
        this.objectMapper = objectMapper;
        this.setSupportedMediaTypes(Collections.singletonList(MediaType.APPLICATION_JSON));
    }

    protected void writeInternal(Object object, @Nullable Type type, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        if (object instanceof MappingJacksonValue) {
            MappingJacksonValue mappingJacksonValueObject = (MappingJacksonValue)object;
            mappingJacksonValueObject.setValue(this.transformObject(mappingJacksonValueObject.getValue()));
            this.defaultWriteInternal(mappingJacksonValueObject, type, outputMessage);
        } else {
            this.defaultWriteInternal(this.transformObject(object), type, outputMessage);
        }
    }

    private Object transformObject(Object object) {
        if (object instanceof PagedModel) {
            return this.pagedCollectionModelConverter.pagedCollectionModelToListResponseContent((PagedModel)object);
        }
        if (object instanceof CollectionModel) {
            return this.pagedCollectionModelConverter.resourcesToListResponseContent((CollectionModel)object);
        }
        if (object instanceof EntityModel) {
            return new EntryResponseContent<Object>(((EntityModel)object).getContent());
        }
        return object;
    }

    protected void defaultWriteInternal(Object object, @Nullable Type type, HttpOutputMessage outputMessage) throws IOException {
        super.writeInternal(object, type, outputMessage);
    }

    public boolean canWrite(Type type, Class<?> clazz, MediaType mediaType) {
        return !String.class.equals((Object)type) && super.canWrite(type, clazz, mediaType);
    }
}

