/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.alfresco.data.domain;

import org.activiti.cloud.alfresco.data.domain.ExtendedPageMetadata;
import org.springframework.hateoas.PagedModel;

public class ExtendedPageMetadataConverter {
    public ExtendedPageMetadata toExtendedPageMetadata(long skipCount, PagedModel.PageMetadata basePageMetadata) {
        long totalPages = basePageMetadata.getTotalPages();
        int skipCountRemainder = Math.toIntExact(skipCount % basePageMetadata.getSize());
        if (skipCountRemainder != 0) {
            int firstPageSize = skipCountRemainder;
            long totalElementsNotInTheFirstPage = basePageMetadata.getTotalElements() - (long)firstPageSize;
            totalPages = new PagedModel.PageMetadata(basePageMetadata.getSize(), basePageMetadata.getNumber(), totalElementsNotInTheFirstPage).getTotalPages() + 1L;
        }
        return new ExtendedPageMetadata(skipCount, basePageMetadata.getSize(), basePageMetadata.getNumber(), basePageMetadata.getTotalElements(), totalPages);
    }
}

