/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.alfresco.argument.resolver;

import org.activiti.cloud.alfresco.argument.resolver.AlfrescoPageParameterParser;
import org.activiti.cloud.alfresco.argument.resolver.AlfrescoPageRequest;
import org.activiti.cloud.alfresco.argument.resolver.AlfrescoQueryParameters;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableArgumentResolver;
import org.springframework.data.web.PageableHandlerMethodArgumentResolver;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;

public class AlfrescoPageArgumentMethodResolver
implements PageableArgumentResolver {
    private final AlfrescoPageParameterParser pageParameterParser;
    private final PageableHandlerMethodArgumentResolver pageableHandlerMethodArgumentResolver;
    private final int maxItemsLimit;
    private final boolean maxItemsLimitEnabled;

    public AlfrescoPageArgumentMethodResolver(AlfrescoPageParameterParser pageParameterParser, PageableHandlerMethodArgumentResolver pageableHandlerMethodArgumentResolver, int maxItemsLimit, boolean maxItemsLimitEnabled) {
        this.pageParameterParser = pageParameterParser;
        this.pageableHandlerMethodArgumentResolver = pageableHandlerMethodArgumentResolver;
        this.maxItemsLimit = maxItemsLimit;
        this.maxItemsLimitEnabled = maxItemsLimitEnabled;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.getParameterType().equals(Pageable.class);
    }

    @Nullable
    public Pageable resolveArgument(MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) {
        Pageable basePageable = this.pageableHandlerMethodArgumentResolver.resolveArgument(parameter, mavContainer, webRequest, binderFactory);
        AlfrescoQueryParameters alfrescoQueryParameters = this.pageParameterParser.parseParameters(webRequest);
        if (this.isPaginationValueExceedingLimit(alfrescoQueryParameters, basePageable)) {
            throw new IllegalStateException("Exceeded max limit of " + this.maxItemsLimit + " elements");
        }
        if (alfrescoQueryParameters.getSkipCountParameter().isSet() || alfrescoQueryParameters.getMaxItemsParameter().isSet()) {
            return new AlfrescoPageRequest((Long)alfrescoQueryParameters.getSkipCountParameter().getValue(), (Integer)alfrescoQueryParameters.getMaxItemsParameter().getValue(), basePageable);
        }
        return basePageable;
    }

    private boolean isPaginationValueExceedingLimit(AlfrescoQueryParameters alfrescoQueryParameters, Pageable basePageable) {
        if (this.maxItemsLimitEnabled) {
            if (alfrescoQueryParameters.getMaxItemsParameter().isSet()) {
                return (Integer)alfrescoQueryParameters.getMaxItemsParameter().getValue() > this.maxItemsLimit;
            }
            return basePageable.getPageSize() > this.maxItemsLimit;
        }
        return false;
    }
}

