/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.services.connectors.channel;

import org.activiti.api.process.model.IntegrationContext;
import org.activiti.api.runtime.model.impl.IntegrationContextImpl;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.process.model.IntegrationError;
import org.activiti.cloud.api.process.model.impl.events.CloudIntegrationErrorReceivedEventImpl;
import org.activiti.cloud.services.events.configuration.RuntimeBundleProperties;
import org.activiti.cloud.services.events.listeners.ProcessEngineEventsAggregator;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;

class AggregateIntegrationErrorReceivedEventCmd
implements Command<Void> {
    private final IntegrationError integrationError;
    private final RuntimeBundleProperties runtimeBundleProperties;
    private final ProcessEngineEventsAggregator processEngineEventsAggregator;

    AggregateIntegrationErrorReceivedEventCmd(IntegrationError integrationError, RuntimeBundleProperties runtimeBundleProperties, ProcessEngineEventsAggregator processEngineEventsAggregator) {
        this.integrationError = integrationError;
        this.runtimeBundleProperties = runtimeBundleProperties;
        this.processEngineEventsAggregator = processEngineEventsAggregator;
    }

    public Void execute(CommandContext commandContext) {
        if (this.runtimeBundleProperties.getEventsProperties().isIntegrationAuditEventsEnabled()) {
            CloudIntegrationErrorReceivedEventImpl integrationErrorReceived;
            if (this.integrationError.getIntegrationContext().hasEphemeralVariables()) {
                IntegrationContextImpl sanitizedContext = new IntegrationContextImpl(this.integrationError.getIntegrationContext());
                sanitizedContext.clearOutBoundVariables();
                sanitizedContext.clearInBoundVariables();
                integrationErrorReceived = this.createIntegrationErrorReceivedEvent((IntegrationContext)sanitizedContext);
            } else {
                integrationErrorReceived = this.createIntegrationErrorReceivedEvent(this.integrationError.getIntegrationContext());
            }
            this.processEngineEventsAggregator.add((CloudRuntimeEvent)integrationErrorReceived);
        }
        return null;
    }

    private CloudIntegrationErrorReceivedEventImpl createIntegrationErrorReceivedEvent(IntegrationContext integrationContext) {
        return new CloudIntegrationErrorReceivedEventImpl(integrationContext, this.integrationError.getErrorCode(), this.integrationError.getErrorMessage(), this.integrationError.getErrorClassName(), this.integrationError.getStackTraceElements());
    }
}

