/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.services.connectors.channel;

import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ManagementService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.services.connectors.behavior.MQServiceTaskBehavior;

public class IntegrationRequestReplayer {
    private final RuntimeService runtimeService;
    private final ManagementService managementService;
    private final MQServiceTaskBehavior mqServiceTaskBehavior;

    public IntegrationRequestReplayer(RuntimeService runtimeService, ManagementService managementService, MQServiceTaskBehavior mqServiceTaskBehavior) {
        this.runtimeService = runtimeService;
        this.managementService = managementService;
        this.mqServiceTaskBehavior = mqServiceTaskBehavior;
    }

    public void replay(String executionId, String flowNodeId) {
        List executions = this.runtimeService.createExecutionQuery().executionId(executionId).activityId(flowNodeId).list();
        if (executions.isEmpty()) {
            String message = "Unable to replay integration request because no task is in this RB is waiting for integration result with execution id `" + executionId + ", flow node id `" + flowNodeId + "'";
            throw new ActivitiException(message);
        }
        ExecutionEntity execution = (ExecutionEntity)executions.get(0);
        this.managementService.executeCommand(commandContext -> {
            this.mqServiceTaskBehavior.apply((DelegateExecution)execution);
            return null;
        });
    }
}

