/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.services.connectors.conf;

import java.util.Map;
import org.activiti.services.connectors.conf.ConnectorDestinationMappingStrategy;
import org.activiti.services.connectors.conf.ConnectorImplementationsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.core.Ordered;

public class ConnectorMessagingDestinationsConfigurer
implements InitializingBean,
Ordered {
    private static final Logger logger = LoggerFactory.getLogger(ConnectorImplementationsProvider.class);
    private final ConnectorImplementationsProvider destinationsProvider;
    private final ConnectorDestinationMappingStrategy destinationMappingStrategy;
    private final BindingServiceProperties bindingServiceProperties;

    public ConnectorMessagingDestinationsConfigurer(ConnectorImplementationsProvider destinationsProvider, ConnectorDestinationMappingStrategy destinationMappingStrategy, BindingServiceProperties bindingServiceProperties) {
        this.destinationsProvider = destinationsProvider;
        this.destinationMappingStrategy = destinationMappingStrategy;
        this.bindingServiceProperties = bindingServiceProperties;
    }

    public void afterPropertiesSet() throws Exception {
        this.destinationsProvider.getImplementations().stream().map(this::resolveBindingDestination).map(this::applyBindingDestination).forEach(this::log);
    }

    protected Map.Entry<String, String> resolveBindingDestination(String implementation) {
        String destination = this.destinationMappingStrategy.apply(implementation);
        return Map.entry(implementation, destination);
    }

    protected Map.Entry<String, BindingProperties> applyBindingDestination(Map.Entry<String, String> entry) {
        BindingProperties bindingProperties = this.bindingServiceProperties.getBindingProperties(entry.getKey());
        bindingProperties.setDestination(entry.getValue());
        return Map.entry(entry.getKey(), bindingProperties);
    }

    protected void log(Map.Entry<String, BindingProperties> entry) {
        logger.warn("Configured Connector '{}' implementation to '{}' destination", (Object)entry.getKey(), (Object)entry.getValue().getDestination());
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

