/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.services.connectors.channel;

import org.activiti.cloud.api.process.model.IntegrationError;
import org.activiti.cloud.api.process.model.impl.IntegrationErrorImpl;
import org.activiti.cloud.services.events.configuration.RuntimeBundleProperties;
import org.activiti.cloud.services.events.listeners.ProcessEngineEventsAggregator;
import org.activiti.engine.ManagementService;
import org.activiti.engine.impl.cmd.integration.DeleteIntegrationContextCmd;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.persistence.entity.integration.IntegrationContextEntity;
import org.activiti.services.connectors.channel.AggregateIntegrationErrorReceivedEventCmd;
import org.activiti.services.connectors.channel.CompositeCommand;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class ServiceTaskIntegrationCompletionHandler {
    private final RuntimeBundleProperties runtimeBundleProperties;
    private final ManagementService managementService;
    private final ProcessEngineEventsAggregator processEngineEventsAggregator;

    public ServiceTaskIntegrationCompletionHandler(RuntimeBundleProperties runtimeBundleProperties, ManagementService managementService, ProcessEngineEventsAggregator processEngineEventsAggregator) {
        this.runtimeBundleProperties = runtimeBundleProperties;
        this.managementService = managementService;
        this.processEngineEventsAggregator = processEngineEventsAggregator;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void handlePropagationFailure(IntegrationErrorImpl integrationError, IntegrationContextEntity integrationContextEntity) {
        CompositeCommand finalErrorHandlingCmd = CompositeCommand.of(new Command[]{new AggregateIntegrationErrorReceivedEventCmd((IntegrationError)integrationError, this.runtimeBundleProperties, this.processEngineEventsAggregator), new DeleteIntegrationContextCmd(integrationContextEntity)});
        this.managementService.executeCommand((Command)finalErrorHandlingCmd);
    }
}

