/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.services.connectors;

import org.activiti.cloud.api.process.model.IntegrationRequest;
import org.activiti.cloud.common.messaging.config.FunctionBindingConfiguration;
import org.activiti.services.connectors.message.IntegrationContextMessageBuilderFactory;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.messaging.Message;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class IntegrationRequestSender {
    public static final String CONNECTOR_TYPE = "connectorType";
    private final StreamBridge streamBridge;
    private final IntegrationContextMessageBuilderFactory messageBuilderFactory;
    private final FunctionBindingConfiguration.BindingResolver bindingResolver;

    public IntegrationRequestSender(StreamBridge streamBridge, IntegrationContextMessageBuilderFactory messageBuilderFactory, FunctionBindingConfiguration.BindingResolver bindingResolver) {
        this.streamBridge = streamBridge;
        this.messageBuilderFactory = messageBuilderFactory;
        this.bindingResolver = bindingResolver;
    }

    public void sendIntegrationRequest(final IntegrationRequest event) {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalTransactionStateException("Transaction synchronization must be active.");
        }
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                IntegrationRequestSender.this.streamBridge.send(event.getIntegrationContext().getConnectorType(), IntegrationRequestSender.this.buildIntegrationRequestMessage(event));
            }
        });
    }

    private Message<IntegrationRequest> buildIntegrationRequestMessage(IntegrationRequest event) {
        String destination = this.bindingResolver.getBindingDestination(event.getIntegrationContext().getConnectorType());
        return this.messageBuilderFactory.create(event.getIntegrationContext()).withPayload((Object)event).setHeader("spring.cloud.function.destination", (Object)this.bindingResolver.getBindingDestination(destination)).build();
    }
}

