/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.activiti.cloud.services.common.util.ImageProcessingException;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;

public class ImageUtils {
    private ImageUtils() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] svgToPng(byte[] streamBytes) throws IOException, ImageProcessingException {
        try (ByteArrayInputStream input = new ByteArrayInputStream(streamBytes);){
            byte[] byArray;
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                new PNGTranscoder().transcode(new TranscoderInput((InputStream)input), new TranscoderOutput((OutputStream)output));
                output.flush();
                byArray = output.toByteArray();
            }
            return byArray;
        }
        catch (TranscoderException e) {
            throw new ImageProcessingException(e);
        }
    }
}

