/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.common.util;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.activiti.cloud.services.common.file.FileContent;
import org.springframework.util.StreamUtils;
import org.springframework.web.multipart.MultipartFile;

public final class HttpUtils {
    public static final String HEADER_ATTACHEMNT_FILENAME = "attachment;filename=";
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static void writeFileToResponse(HttpServletResponse response, FileContent fileContent, boolean attachment) throws IOException {
        response.setContentType(fileContent.getContentType());
        if (attachment) {
            response.setHeader("Content-Disposition", HEADER_ATTACHEMNT_FILENAME + fileContent.getFilename());
        }
        HttpUtils.writeChunked(fileContent.getFileContent(), (OutputStream)response.getOutputStream());
    }

    public static FileContent multipartToFileContent(MultipartFile file) throws IOException {
        return new FileContent(file.getOriginalFilename(), file.getContentType(), StreamUtils.copyToByteArray((InputStream)file.getInputStream()));
    }

    private HttpUtils() {
    }

    private static void writeChunked(byte[] data, OutputStream output) throws IOException {
        if (data != null) {
            int bytes = data.length;
            int offset = 0;
            while (bytes > 0) {
                int chunk = Math.min(bytes, 4096);
                output.write(data, offset, chunk);
                bytes -= chunk;
                offset += chunk;
            }
        }
    }
}

