/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Optional;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.StreamUtils;

public class FileUtils {
    public static byte[] resourceAsByteArray(String path) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(new ClassPathResource(path).getFile());){
            byte[] byArray = StreamUtils.copyToByteArray((InputStream)inputStream);
            return byArray;
        }
    }

    public static Optional<File> resourceAsFile(String name) {
        ClassLoader classLoader = FileUtils.classLoader();
        return Optional.ofNullable(name).map(classLoader::getResource).map(URL::getFile).map(File::new);
    }

    public static Optional<InputStream> resourceAsStream(String name) {
        ClassLoader classLoader = FileUtils.classLoader();
        return Optional.ofNullable(name).map(classLoader::getResourceAsStream);
    }

    public static ClassLoader classLoader() {
        return FileUtils.class.getClassLoader();
    }
}

