/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.common.util;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.springframework.boot.web.server.MimeMappings;

public final class ContentTypeUtils {
    public static final String JSON = "json";
    public static final String DMN = "dmn";
    public static final String XML = "xml";
    public static final String CONTENT_TYPE_JSON = MimeMappings.DEFAULT.get("json");
    public static final String CONTENT_TYPE_XML = MimeMappings.DEFAULT.get("xml");
    public static final String CONTENT_TYPE_SVG = "image/svg+xml";
    public static final String CONTENT_TYPE_PNG = "image/png";
    public static final String CONTENT_TYPE_ZIP = "application/zip";
    private static final String EMPTY_STRING = "";
    public static final char EXTENSION_SEPARATOR = '.';
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final int NOT_FOUND = -1;
    public static final Map<String, String> CONTENT_TYPES = Collections.singletonMap("dmn", CONTENT_TYPE_XML);

    public static Optional<String> getContentTypeByExtension(String extension) {
        return Optional.ofNullable(Optional.ofNullable(MimeMappings.DEFAULT.get(extension)).orElseGet(() -> CONTENT_TYPES.get(extension)));
    }

    public static Optional<String> getContentTypeByPath(String path) {
        return ContentTypeUtils.getContentTypeByExtension(ContentTypeUtils.getExtension(path));
    }

    public static boolean isJsonContentType(String contentType) {
        return CONTENT_TYPE_JSON.equals(contentType);
    }

    public static boolean isSvgContentType(String contentType) {
        return CONTENT_TYPE_SVG.equals(contentType);
    }

    public static String toJsonFilename(String filename) {
        return ContentTypeUtils.setExtension(filename, JSON);
    }

    public static String changeToJsonFilename(String filename) {
        return ContentTypeUtils.changeExtension(filename, JSON);
    }

    public static String setExtension(String filename, String extension) {
        if (filename == null) {
            return null;
        }
        return Optional.ofNullable(extension).map(ContentTypeUtils::fullExtension).filter(ext -> !filename.endsWith((String)ext)).map(fullExtension -> filename + fullExtension).orElse(filename);
    }

    public static String changeExtension(String filename, String extension) {
        if (filename == null) {
            return null;
        }
        return Optional.ofNullable(extension).map(ContentTypeUtils::fullExtension).filter(ext -> !filename.endsWith((String)ext)).map(fullExtension -> ContentTypeUtils.removeExtension(filename) + fullExtension).orElse(filename);
    }

    public static String removeExtension(String filename, String extension) {
        if (filename == null) {
            return null;
        }
        return Optional.ofNullable(extension).map(ContentTypeUtils::fullExtension).filter(filename::endsWith).map(filename::lastIndexOf).map(extensionIndex -> filename.substring(0, (int)extensionIndex)).orElse(filename);
    }

    public static String fullExtension(String extension) {
        return "." + extension;
    }

    private ContentTypeUtils() {
    }

    static String getExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int index = ContentTypeUtils.getIndexOfExtension(fileName);
        if (index == -1) {
            return EMPTY_STRING;
        }
        return fileName.substring(index + 1);
    }

    private static int getIndexOfExtension(String path) {
        int lastWindowsPos;
        int extensionPos = path.lastIndexOf(46);
        int lastUnixPos = path.lastIndexOf(47);
        int lastSeparator = Math.max(lastUnixPos, lastWindowsPos = path.lastIndexOf(92));
        int index = lastSeparator > extensionPos ? -1 : extensionPos;
        return index;
    }

    static String removeExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int index = ContentTypeUtils.getIndexOfExtension(fileName);
        if (index == -1) {
            return fileName;
        }
        return fileName.substring(0, index);
    }
}

