/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.common.security.jwt.validator;

import org.activiti.cloud.services.common.security.jwt.validator.AbastractTimeValidationCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.jwt.Jwt;

public class IsNotBeforeValidationCheck
implements AbastractTimeValidationCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsNotBeforeValidationCheck.class);
    private final long offset;

    public IsNotBeforeValidationCheck(long offset) {
        this.offset = offset;
    }

    @Override
    public boolean isValid(Jwt accessToken) {
        boolean result;
        long currentTime = this.currentTime(this.offset);
        boolean bl = result = accessToken.getNotBefore() == null || currentTime >= accessToken.getNotBefore().toEpochMilli();
        if (!result) {
            LOGGER.error("Current time {} is before {}", (Object)currentTime, (Object)accessToken.getNotBefore());
        }
        return result;
    }
}

