/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.security.feign.configuration;

import org.activiti.cloud.security.feign.ClientCredentialsAuthRequestInterceptor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.oauth2.client.AuthorizedClientServiceOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProviderBuilder;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;

public class ClientCredentialsAuthConfiguration {
    public ClientCredentialsAuthRequestInterceptor clientCredentialsAuthRequestInterceptor(OAuth2AuthorizedClientService oAuth2AuthorizedClientService, ClientRegistrationRepository clientRegistrationRepository, ClientRegistration clientRegistration) {
        return this.clientCredentialsAuthRequestInterceptor(oAuth2AuthorizedClientService, clientRegistrationRepository, clientRegistration, null);
    }

    public ClientCredentialsAuthRequestInterceptor clientCredentialsAuthRequestInterceptor(OAuth2AuthorizedClientService oAuth2AuthorizedClientService, ClientRegistrationRepository clientRegistrationRepository, ClientRegistration clientRegistration, OAuth2AuthorizedClientProvider provider) {
        AuthorizedClientServiceOAuth2AuthorizedClientManager authorizedClientManager = new AuthorizedClientServiceOAuth2AuthorizedClientManager(clientRegistrationRepository, oAuth2AuthorizedClientService);
        OAuth2AuthorizedClientProviderBuilder oAuth2AuthorizedClientProviderBuilder = OAuth2AuthorizedClientProviderBuilder.builder().refreshToken().clientCredentials();
        OAuth2AuthorizedClientProvider authorizedClientProvider = provider == null ? oAuth2AuthorizedClientProviderBuilder.build() : oAuth2AuthorizedClientProviderBuilder.provider(provider).build();
        authorizedClientManager.setAuthorizedClientProvider(authorizedClientProvider);
        return new ClientCredentialsAuthRequestInterceptor((OAuth2AuthorizedClientManager)authorizedClientManager, clientRegistration);
    }

    public ClientRegistration clientRegistration(ClientRegistrationRepository clientRegistrationRepository, @Value(value="${activiti.cloud.services.oauth2.iam-name:keycloak}") String clientName) {
        return clientRegistrationRepository.findByRegistrationId(clientName);
    }
}

