/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.identity.web.controller;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.activiti.cloud.identity.exceptions.IdentityInvalidApplicationException;
import org.activiti.cloud.identity.exceptions.IdentityInvalidGroupException;
import org.activiti.cloud.identity.exceptions.IdentityInvalidGroupRoleException;
import org.activiti.cloud.identity.exceptions.IdentityInvalidRoleException;
import org.activiti.cloud.identity.exceptions.IdentityInvalidUserException;
import org.activiti.cloud.identity.exceptions.IdentityInvalidUserRoleException;
import org.activiti.cloud.identity.exceptions.IdentityInvalidUserTypeException;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@Order(value=-2147483648)
public class IdentityManagementRestExceptionHandler {
    @ExceptionHandler(value={IdentityInvalidUserRoleException.class, IdentityInvalidUserException.class, IdentityInvalidRoleException.class, IdentityInvalidGroupException.class, IdentityInvalidGroupRoleException.class, IdentityInvalidUserTypeException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public void handleAppException(Exception ex, HttpServletResponse response) throws IOException {
        response.sendError(HttpStatus.BAD_REQUEST.value(), ex.getMessage());
    }

    @ExceptionHandler(value={IdentityInvalidApplicationException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public void handleAppException(IdentityInvalidApplicationException ex, HttpServletResponse response) throws IOException {
        response.sendError(HttpStatus.NOT_FOUND.value(), ex.getMessage());
    }
}

