/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.security.authorization;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class CsrfIgnoreMatcher
implements RequestMatcher {
    private final List<String> publicUrls;
    private final PathMatcher matcher;

    public CsrfIgnoreMatcher(List<String> publicUrls) {
        this.publicUrls = publicUrls;
        this.matcher = new AntPathMatcher();
    }

    public boolean matches(HttpServletRequest request) {
        return this.publicUrls.stream().anyMatch(url -> this.matcher.match(url, request.getRequestURI()));
    }
}

