/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.common.security.jwt;

import java.security.Principal;
import java.util.List;
import org.activiti.api.runtime.shared.security.PrincipalRolesProvider;
import org.activiti.cloud.services.common.security.jwt.JwtAccessTokenProvider;
import org.activiti.cloud.services.common.security.jwt.JwtAccessTokenValidator;
import org.activiti.cloud.services.common.security.jwt.JwtAdapter;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class JtwAccessTokenPrincipalRolesProvider
implements PrincipalRolesProvider {
    private final JwtAccessTokenProvider jwtAccessTokenProvider;
    private final JwtAccessTokenValidator jwtAccessTokenValidator;

    public JtwAccessTokenPrincipalRolesProvider(@NonNull JwtAccessTokenProvider keycloakSecurityContextProvider, @NonNull JwtAccessTokenValidator jwtAccessTokenValidator) {
        this.jwtAccessTokenProvider = keycloakSecurityContextProvider;
        this.jwtAccessTokenValidator = jwtAccessTokenValidator;
    }

    public List<String> getRoles(@NonNull Principal principal) {
        return this.jwtAccessTokenProvider.accessToken(principal).filter(this.jwtAccessTokenValidator::isValid).map(JwtAdapter::getRoles).orElseGet(this::empty);
    }

    @Nullable
    protected List<String> empty() {
        return null;
    }
}

