/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.common.security.keycloak;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.activiti.cloud.services.common.security.jwt.JwtAdapter;
import org.springframework.security.oauth2.jwt.Jwt;

public class KeycloakJwtAdapter
implements JwtAdapter {
    private final Jwt jwt;

    public KeycloakJwtAdapter(Jwt jwt) {
        this.jwt = jwt;
    }

    public Jwt getJwt() {
        return this.jwt;
    }

    public List<String> getRoles() {
        if (this.jwt.hasClaim("realm_access")) {
            return this.getRoles((Map)this.jwt.getClaim("realm_access"));
        }
        return Collections.emptyList();
    }

    public String getUserName() {
        return (String)this.jwt.getClaim("preferred_username");
    }

    public List<String> getGroups() {
        if (this.jwt.hasClaim("groups")) {
            return this.jwt.getClaimAsStringList("groups");
        }
        return null;
    }

    private List<String> getRoles(Map<String, Object> getRolesParent) {
        return (List)getRolesParent.get("roles");
    }

    public List<String> getScopes() {
        return this.jwt.getClaimAsStringList("scope");
    }
}

