/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.identity.keycloak.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.activiti.cloud.identity.IdentityClientRepresentation;

public class KeycloakClientRepresentation
implements IdentityClientRepresentation {
    private String id;
    private String clientId;
    private String name;
    private Boolean enabled;
    private Boolean standardFlowEnabled;
    private Boolean directAccessGrantsEnabled;
    private Boolean authorizationServicesEnabled;
    private String secret;
    private List<String> redirectUris;
    private List<String> webOrigins;
    private Boolean publicClient;
    private Boolean implicitFlowEnabled;
    private Boolean serviceAccountsEnabled;
    private ClientAttributes attributes;

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getStandardFlowEnabled() {
        return this.standardFlowEnabled;
    }

    public void setStandardFlowEnabled(Boolean standardFlowEnabled) {
        this.standardFlowEnabled = standardFlowEnabled;
    }

    public Boolean getDirectAccessGrantsEnabled() {
        return this.directAccessGrantsEnabled;
    }

    public void setDirectAccessGrantsEnabled(Boolean directAccessGrantsEnabled) {
        this.directAccessGrantsEnabled = directAccessGrantsEnabled;
    }

    public Boolean getAuthorizationServicesEnabled() {
        return this.authorizationServicesEnabled;
    }

    public void setAuthorizationServicesEnabled(Boolean authorizationServicesEnabled) {
        this.authorizationServicesEnabled = authorizationServicesEnabled;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public List<String> getRedirectUris() {
        return this.redirectUris;
    }

    public void setRedirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
    }

    public List<String> getWebOrigins() {
        return this.webOrigins;
    }

    public void setWebOrigins(List<String> webOrigins) {
        this.webOrigins = webOrigins;
    }

    public Boolean getPublicClient() {
        return this.publicClient;
    }

    public void setPublicClient(Boolean publicClient) {
        this.publicClient = publicClient;
    }

    public Boolean getImplicitFlowEnabled() {
        return this.implicitFlowEnabled;
    }

    public void setImplicitFlowEnabled(Boolean implicitFlowEnabled) {
        this.implicitFlowEnabled = implicitFlowEnabled;
    }

    public Boolean getServiceAccountsEnabled() {
        return this.serviceAccountsEnabled;
    }

    public void setServiceAccountsEnabled(Boolean serviceAccountsEnabled) {
        this.serviceAccountsEnabled = serviceAccountsEnabled;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ClientAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(ClientAttributes attributes) {
        this.attributes = attributes;
    }

    public record ClientAttributes(@JsonProperty(value="access.token.lifespan") Integer accessTokenLifespan) {
    }

    public static class Builder {
        private String clientId;
        private String name;
        private Boolean enabled;
        private Boolean standardFlowEnabled;
        private Boolean directAccessGrantsEnabled;
        private Boolean authorizationServicesEnabled;
        private String secret;
        private List<String> redirectUris;
        private List<String> webOrigins;
        private Boolean publicClient;
        private Boolean implicitFlowEnabled;
        private Boolean serviceAccountsEnabled;
        private Integer accessTokenLifespan;

        public static Builder newKeycloakClientRepresentationBuilder() {
            return new Builder();
        }

        public Builder withClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder withClientName(String clientName) {
            this.name = clientName;
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder standardFlowEnabled(Boolean standardFlowEnabled) {
            this.standardFlowEnabled = standardFlowEnabled;
            return this;
        }

        public Builder directAccessGrantsEnabled(Boolean directAccessGrantsEnabled) {
            this.directAccessGrantsEnabled = directAccessGrantsEnabled;
            return this;
        }

        public Builder authorizationServicesEnabled(Boolean authorizationServicesEnabled) {
            this.authorizationServicesEnabled = authorizationServicesEnabled;
            return this;
        }

        public Builder withSecret(String secret) {
            this.secret = secret;
            return this;
        }

        public Builder withRedirectUris(List<String> redirectUris) {
            this.redirectUris = redirectUris;
            return this;
        }

        public Builder withWebOrigins(List<String> webOrigins) {
            this.webOrigins = webOrigins;
            return this;
        }

        public Builder publicClient(Boolean publicClient) {
            this.publicClient = publicClient;
            return this;
        }

        public Builder implicitFlowEnabled(Boolean implicitFlowEnabled) {
            this.implicitFlowEnabled = implicitFlowEnabled;
            return this;
        }

        public Builder serviceAccountsEnabled(Boolean serviceAccountsEnabled) {
            this.serviceAccountsEnabled = serviceAccountsEnabled;
            return this;
        }

        public Builder withAccessTokenLifespanInSeconds(Integer accessTokenLifespan) {
            this.accessTokenLifespan = accessTokenLifespan;
            return this;
        }

        public KeycloakClientRepresentation build() {
            KeycloakClientRepresentation keycloakClientRepresentation = new KeycloakClientRepresentation();
            keycloakClientRepresentation.setClientId(this.clientId);
            keycloakClientRepresentation.setName(this.name);
            keycloakClientRepresentation.setEnabled(this.enabled);
            keycloakClientRepresentation.setStandardFlowEnabled(this.standardFlowEnabled);
            keycloakClientRepresentation.setDirectAccessGrantsEnabled(this.directAccessGrantsEnabled);
            keycloakClientRepresentation.setAuthorizationServicesEnabled(this.authorizationServicesEnabled);
            keycloakClientRepresentation.setSecret(this.secret);
            keycloakClientRepresentation.setRedirectUris(this.redirectUris);
            keycloakClientRepresentation.setWebOrigins(this.webOrigins);
            keycloakClientRepresentation.setPublicClient(this.publicClient);
            keycloakClientRepresentation.setImplicitFlowEnabled(this.implicitFlowEnabled);
            keycloakClientRepresentation.setServiceAccountsEnabled(this.serviceAccountsEnabled);
            if (this.accessTokenLifespan != null) {
                keycloakClientRepresentation.setAttributes(new ClientAttributes(this.accessTokenLifespan));
            }
            return keycloakClientRepresentation;
        }
    }
}

