/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.identity.keycloak;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.activiti.cloud.identity.GroupSearchParams;
import org.activiti.cloud.identity.IdentityManagementService;
import org.activiti.cloud.identity.IdentityService;
import org.activiti.cloud.identity.UserSearchParams;
import org.activiti.cloud.identity.UserTypeSearchParam;
import org.activiti.cloud.identity.exceptions.IdentityInvalidApplicationException;
import org.activiti.cloud.identity.exceptions.IdentityInvalidGroupException;
import org.activiti.cloud.identity.exceptions.IdentityInvalidGroupRoleException;
import org.activiti.cloud.identity.exceptions.IdentityInvalidRoleException;
import org.activiti.cloud.identity.exceptions.IdentityInvalidUserException;
import org.activiti.cloud.identity.exceptions.IdentityInvalidUserRoleException;
import org.activiti.cloud.identity.model.Group;
import org.activiti.cloud.identity.model.Role;
import org.activiti.cloud.identity.model.SecurityRequestBodyRepresentation;
import org.activiti.cloud.identity.model.SecurityResponseRepresentation;
import org.activiti.cloud.identity.model.User;
import org.activiti.cloud.services.identity.keycloak.client.KeycloakClient;
import org.activiti.cloud.services.identity.keycloak.mapper.KeycloakGroupToGroup;
import org.activiti.cloud.services.identity.keycloak.mapper.KeycloakRoleMappingToRole;
import org.activiti.cloud.services.identity.keycloak.mapper.KeycloakUserToUser;
import org.activiti.cloud.services.identity.keycloak.model.KeycloakClientRepresentation;
import org.activiti.cloud.services.identity.keycloak.model.KeycloakRoleMapping;
import org.activiti.cloud.services.identity.keycloak.model.KeycloakUser;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class KeycloakManagementService
implements IdentityManagementService,
IdentityService {
    public static final int PAGE_START = 0;
    public static final int PAGE_SIZE = 50;
    public static final UserTypeSearchParam DEFAULT_USERTYPE = UserTypeSearchParam.INTERACTIVE;
    private final KeycloakClient keycloakClient;

    public KeycloakManagementService(KeycloakClient keycloakClient) {
        this.keycloakClient = keycloakClient;
    }

    public List<User> findUsers(UserSearchParams userSearchParams) {
        List<User> users;
        UserTypeSearchParam userTypeSearchParam = userSearchParams.getType() == null ? DEFAULT_USERTYPE : userSearchParams.getType();
        List<User> list = users = ObjectUtils.isEmpty((Object)userSearchParams.getGroups()) ? this.searchUsers(userSearchParams.getSearchKey(), userTypeSearchParam, userSearchParams.isFilterDeactivatedUsers()) : this.searchUsers(userSearchParams.getGroups(), userSearchParams.getSearchKey());
        if (!StringUtils.isEmpty((CharSequence)userSearchParams.getApplication())) {
            return this.filterUsersInApplicationsScope(users, userSearchParams);
        }
        return this.filterUsersInRealmScope(users, userSearchParams);
    }

    private List<User> searchUsers(String searchKey, UserTypeSearchParam userType, boolean filterDeactivatedUsers) {
        return switch (userType) {
            default -> throw new MatchException(null, null);
            case UserTypeSearchParam.INTERACTIVE -> this.searchUsers(searchKey, filterDeactivatedUsers);
            case UserTypeSearchParam.ALL -> this.searchUsersByUsername(searchKey);
        };
    }

    private List<User> searchUsers(String searchKey, boolean filterDeactivatedUsers) {
        Predicate<KeycloakUser> shouldFilterUser = user -> !filterDeactivatedUsers || user.isEnabled();
        return this.keycloakClient.searchUsers(searchKey, 0, 50).stream().filter(shouldFilterUser).map(KeycloakUserToUser::toUser).collect(Collectors.toList());
    }

    private List<User> searchUsersByUsername(String searchKey) {
        return this.keycloakClient.searchUsersByUsername(searchKey).stream().map(KeycloakUserToUser::toUser).collect(Collectors.toList());
    }

    private List<User> searchUsers(Set<String> groups, String searchKey) {
        Predicate<User> maybeMatchSearchKey = user -> !StringUtils.isEmpty((CharSequence)searchKey) ? StringUtils.contains((CharSequence)user.getUsername(), (CharSequence)searchKey) || StringUtils.contains((CharSequence)user.getEmail(), (CharSequence)searchKey) : true;
        try {
            ArrayList<User> users = new ArrayList<User>();
            String firstGroup = groups.iterator().next();
            users.addAll(this.findUsersByGroupName(firstGroup));
            groups.forEach(group -> users.retainAll(this.findUsersByGroupName((String)group)));
            return users.stream().filter(maybeMatchSearchKey).collect(Collectors.toList());
        }
        catch (IdentityInvalidGroupException exception) {
            return Collections.emptyList();
        }
    }

    private List<User> filterUsersInRealmScope(List<User> users, UserSearchParams userSearchParams) {
        HashMap<String, List<Role>> usersRolesMapping = new HashMap<String, List<Role>>();
        if (!CollectionUtils.isEmpty((Collection)userSearchParams.getRoles())) {
            this.mapUserWithRealmRoles(users, usersRolesMapping);
        }
        return users.stream().filter(user -> this.filterByRoles((List)usersRolesMapping.get(user.getId()), userSearchParams.getRoles())).collect(Collectors.toList());
    }

    private void mapUserWithRealmRoles(List<User> users, Map<String, List<Role>> usersRolesMapping) {
        users.forEach(user -> usersRolesMapping.put(user.getId(), this.getUserRealmRoles(user.getId())));
    }

    private List<Role> getUserRealmRoles(String userId) {
        return KeycloakRoleMappingToRole.toRoles(this.keycloakClient.getUserRoleMapping(userId));
    }

    private List<User> filterUsersInApplicationsScope(List<User> users, UserSearchParams userSearchParams) {
        String application = userSearchParams.getApplication();
        String kClientId = this.getKeycloakClientId(application);
        if (StringUtils.isEmpty((CharSequence)kClientId)) {
            return Collections.emptyList();
        }
        Map<String, List<Role>> userAppRoles = this.mapUsersWithApplicationRoles(users, kClientId);
        return users.stream().filter(user -> this.filterByApplication((List)userAppRoles.get(user.getId()))).filter(user -> this.filterByRoles((List)userAppRoles.get(user.getId()), userSearchParams.getRoles())).collect(Collectors.toList());
    }

    private Map<String, List<Role>> mapUsersWithApplicationRoles(List<User> users, String kClientId) {
        return users.stream().collect(Collectors.toMap(User::getId, user -> this.getUserApplicationRoles(user.getId(), kClientId)));
    }

    public List<Group> findGroups(GroupSearchParams groupSearchParams) {
        List<Group> groups = this.searchGroups(groupSearchParams.getSearch());
        if (!StringUtils.isEmpty((CharSequence)groupSearchParams.getApplication())) {
            return this.filterGroupsInApplicationsScope(groups, groupSearchParams);
        }
        return this.filterGroupsInRealmScope(groups, groupSearchParams);
    }

    private List<Group> searchGroups(String searchKey) {
        return this.keycloakClient.searchGroups(searchKey, 0, 50).stream().map(KeycloakGroupToGroup::toGroup).collect(Collectors.toList());
    }

    private List<Group> filterGroupsInRealmScope(List<Group> groups, GroupSearchParams groupSearchParams) {
        HashMap<String, List<Role>> groupsRolesMapping = new HashMap<String, List<Role>>();
        if (!CollectionUtils.isEmpty((Collection)groupSearchParams.getRoles())) {
            this.mapGroupsWithRealmRoles(groups, groupsRolesMapping);
        }
        return groups.stream().filter(group -> this.filterByRoles((List)groupsRolesMapping.get(group.getId()), groupSearchParams.getRoles())).collect(Collectors.toList());
    }

    private void mapGroupsWithRealmRoles(List<Group> groups, Map<String, List<Role>> groupsRolesMapping) {
        groups.forEach(group -> groupsRolesMapping.put(group.getId(), this.getGroupRealmRoles(group.getId())));
    }

    private List<Role> getGroupRealmRoles(String groupId) {
        return KeycloakRoleMappingToRole.toRoles(this.keycloakClient.getGroupRoleMapping(groupId));
    }

    private List<Group> filterGroupsInApplicationsScope(List<Group> groups, GroupSearchParams userSearchParams) {
        String application = userSearchParams.getApplication();
        String kClientId = this.getKeycloakClientId(application);
        if (StringUtils.isEmpty((CharSequence)kClientId)) {
            return Collections.emptyList();
        }
        Map<String, List<Role>> groupAppRoles = this.mapGroupsWithApplicationRoles(groups, kClientId);
        return groups.stream().filter(group -> this.filterByApplication((List)groupAppRoles.get(group.getId()))).filter(group -> this.filterByRoles((List)groupAppRoles.get(group.getId()), userSearchParams.getRoles())).collect(Collectors.toList());
    }

    private Map<String, List<Role>> mapGroupsWithApplicationRoles(List<Group> groups, String kClientId) {
        return groups.stream().collect(Collectors.toMap(Group::getId, group -> this.getGroupApplicationRoles(group.getId(), kClientId)));
    }

    private boolean filterByRoles(List<Role> currentRoles, Set<String> filterRoles) {
        return CollectionUtils.isEmpty(filterRoles) || currentRoles != null && currentRoles.stream().map(Role::getName).collect(Collectors.toSet()).containsAll(filterRoles);
    }

    public List<SecurityResponseRepresentation> getApplicationPermissions(String application, Set<String> roles) {
        String clientId = this.getKeycloakClientId(application);
        Set<String> applicationRolesFilter = this.getApplicationRolesToSearch(roles, clientId);
        ArrayList<SecurityResponseRepresentation> applicationPermissions = new ArrayList<SecurityResponseRepresentation>();
        applicationRolesFilter.forEach(role -> {
            SecurityResponseRepresentation securityResponseRepresentation = new SecurityResponseRepresentation();
            securityResponseRepresentation.setRole(role);
            securityResponseRepresentation.setUsers(this.getUsersClientRoleMapping(clientId, (String)role));
            securityResponseRepresentation.setGroups(this.getGroupsClientRoleMapping(clientId, (String)role));
            applicationPermissions.add(securityResponseRepresentation);
        });
        return applicationPermissions;
    }

    public User findUserById(String userId) {
        return Optional.of(this.keycloakClient.getUserById(userId)).map(KeycloakUserToUser::toUser).orElseThrow(() -> new IdentityInvalidUserException(userId));
    }

    public List<User> findUsersByGroupName(String groupName) {
        Group groupFound = this.findGroupStrictlyEqualToGroupName(groupName);
        return this.getUsersByGroupId(groupFound.getId());
    }

    private Group findGroupStrictlyEqualToGroupName(String groupName) {
        return Optional.ofNullable(groupName).filter(Predicate.not(String::isEmpty)).map(g -> this.searchGroups((String)g).stream()).orElse(Stream.empty()).filter(group -> group.getName().equals(groupName)).findFirst().orElseThrow(() -> new IdentityInvalidGroupException(groupName));
    }

    public User findUserByName(String userName) {
        Predicate<User> username = user -> user.getUsername().equalsIgnoreCase(userName);
        Predicate<User> email = user -> user.getEmail().equalsIgnoreCase(userName);
        return this.searchUsers(userName, false).stream().filter(username.or(email)).findFirst().orElseThrow(() -> new IdentityInvalidUserException(userName));
    }

    public Group findGroupByName(String groupName) {
        return this.searchGroups(groupName).stream().filter(group -> group.getName().equalsIgnoreCase(groupName)).findFirst().orElseThrow(() -> new IdentityInvalidGroupException(groupName));
    }

    private List<User> getUsersByGroupId(String groupID) {
        return this.keycloakClient.getUsersByGroupId(groupID).stream().map(KeycloakUserToUser::toUser).collect(Collectors.toList());
    }

    private List<User> getUsersClientRoleMapping(String clientId, String role) {
        return this.keycloakClient.getUsersClientRoleMapping(clientId, role).stream().map(KeycloakUserToUser::toUser).collect(Collectors.toList());
    }

    private List<Group> getGroupsClientRoleMapping(String clientId, String role) {
        return this.keycloakClient.getGroupsClientRoleMapping(clientId, role).stream().map(KeycloakGroupToGroup::toGroup).collect(Collectors.toList());
    }

    private Set<String> getApplicationRolesToSearch(Set<String> roles, String clientId) {
        return this.keycloakClient.getClientRoles(clientId).stream().map(KeycloakRoleMapping::getName).filter(clientRole -> CollectionUtils.isEmpty((Collection)roles) || roles.contains(clientRole)).collect(Collectors.toSet());
    }

    public void addApplicationPermissions(String application, List<SecurityRequestBodyRepresentation> securityRequestBodyRepresentations) {
        String clientId = this.getKeycloakClientId(application);
        if (StringUtils.isEmpty((CharSequence)clientId)) {
            throw new IdentityInvalidApplicationException(application);
        }
        securityRequestBodyRepresentations.forEach(securityRepresentation -> {
            String roleName = securityRepresentation.getRole();
            KeycloakRoleMapping keycloakRoleMapping = this.getKeyCloakRoleFromRoleName(roleName, clientId);
            ArrayList<String> validatedUsers = new ArrayList<String>();
            ArrayList<String> validatedGroups = new ArrayList<String>();
            if (securityRepresentation.getUsers() != null) {
                securityRepresentation.getUsers().forEach(username -> validatedUsers.add(this.validateUserApplicationPermissions((String)username, roleName)));
            }
            if (securityRepresentation.getGroups() != null) {
                securityRepresentation.getGroups().forEach(groupName -> validatedGroups.add(this.validateGroupApplicationPermissions((String)groupName, roleName)));
            }
            this.addApplicationRolePermissions(keycloakRoleMapping, validatedUsers, validatedGroups, clientId);
        });
    }

    private void addApplicationRolePermissions(KeycloakRoleMapping keycloakRoleMapping, List<String> usersId, List<String> groupsId, String clientId) {
        usersId.forEach(userId -> this.keycloakClient.addUserClientRoleMapping((String)userId, clientId, List.of(keycloakRoleMapping)));
        groupsId.forEach(groupId -> this.keycloakClient.addGroupClientRoleMapping((String)groupId, clientId, List.of(keycloakRoleMapping)));
    }

    private KeycloakRoleMapping getKeyCloakRoleFromRoleName(String roleName, String clientId) {
        if (roleName == null) {
            throw new IdentityInvalidRoleException();
        }
        return this.keycloakClient.getClientRoles(clientId).stream().filter(kRole -> kRole.getName().equals(roleName)).findFirst().orElseThrow(() -> new IdentityInvalidRoleException(roleName));
    }

    private String validateUserApplicationPermissions(String username, String roleName) {
        User user = this.getUserFromUsername(username);
        if (!this.userHasRole(user.getId(), roleName)) {
            throw new IdentityInvalidUserRoleException(username, roleName);
        }
        return user.getId();
    }

    private User getUserFromUsername(String username) {
        return this.searchUsers(username, false).stream().filter(u -> u.getUsername().equals(username)).findFirst().orElseThrow(() -> new IdentityInvalidUserException(username));
    }

    private boolean userHasRole(String userId, String role) {
        return this.getUserRealmRoles(userId).stream().anyMatch(userRole -> userRole.getName().equals(role));
    }

    private String validateGroupApplicationPermissions(String groupName, String roleName) {
        Group group = this.getGroupFromGroupName(groupName);
        if (!this.groupHasRole(group.getId(), roleName)) {
            throw new IdentityInvalidGroupRoleException(groupName, roleName);
        }
        return group.getId();
    }

    private Group getGroupFromGroupName(String groupName) {
        return this.searchGroups(groupName).stream().filter(g -> g.getName().equals(groupName)).findFirst().orElseThrow(() -> new IdentityInvalidGroupException(groupName));
    }

    private boolean groupHasRole(String groupId, String role) {
        return this.getGroupRealmRoles(groupId).stream().anyMatch(groupRole -> groupRole.getName().equals(role));
    }

    private boolean filterByApplication(List<Role> applicationRoles) {
        return applicationRoles.stream().findAny().isPresent();
    }

    private List<Role> getUserApplicationRoles(String userId, String clientId) {
        if (!clientId.isEmpty()) {
            return KeycloakRoleMappingToRole.toRoles(this.keycloakClient.getUserClientRoleMapping(userId, clientId));
        }
        return Collections.emptyList();
    }

    private List<Role> getGroupApplicationRoles(String groupId, String clientId) {
        if (!clientId.isEmpty()) {
            return KeycloakRoleMappingToRole.toRoles(this.keycloakClient.getGroupClientRoleMapping(groupId, clientId));
        }
        return Collections.emptyList();
    }

    private String getKeycloakClientId(String application) {
        List<KeycloakClientRepresentation> kClients = this.keycloakClient.searchClients(application, 0, 1);
        return !kClients.isEmpty() ? kClients.get(0).getId() : null;
    }
}

