/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.controllers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.activiti.api.runtime.shared.NotFoundException;
import org.activiti.cloud.alfresco.data.domain.AlfrescoPagedModelAssembler;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.services.audit.api.controllers.AuditEventsController;
import org.activiti.cloud.services.audit.api.converters.APIEventToEntityConverters;
import org.activiti.cloud.services.audit.api.converters.CloudRuntimeEventType;
import org.activiti.cloud.services.audit.api.converters.EventToEntityConverter;
import org.activiti.cloud.services.audit.api.search.SearchParams;
import org.activiti.cloud.services.audit.jpa.assembler.EventRepresentationModelAssembler;
import org.activiti.cloud.services.audit.jpa.controllers.AuditEventsAdminControllerImpl;
import org.activiti.cloud.services.audit.jpa.events.AuditEventEntity;
import org.activiti.cloud.services.audit.jpa.repository.EventSpecificationsBuilder;
import org.activiti.cloud.services.audit.jpa.repository.EventsRepository;
import org.activiti.cloud.services.audit.jpa.repository.SearchOperation;
import org.activiti.cloud.services.audit.jpa.security.SecurityPoliciesApplicationServiceImpl;
import org.activiti.core.common.spring.security.policies.ActivitiForbiddenException;
import org.activiti.core.common.spring.security.policies.SecurityPolicyAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/events"}, produces={"application/hal+json", "application/json"})
public class AuditEventsControllerImpl
implements AuditEventsController {
    private static Logger LOGGER = LoggerFactory.getLogger(AuditEventsAdminControllerImpl.class);
    private final EventsRepository eventsRepository;
    private final EventRepresentationModelAssembler eventRepresentationModelAssembler;
    private final AlfrescoPagedModelAssembler<CloudRuntimeEvent<?, CloudRuntimeEventType>> pagedCollectionModelAssembler;
    private SecurityPoliciesApplicationServiceImpl securityPoliciesApplicationService;
    private final APIEventToEntityConverters eventConverters;

    @Autowired
    public AuditEventsControllerImpl(EventsRepository eventsRepository, EventRepresentationModelAssembler eventRepresentationModelAssembler, APIEventToEntityConverters eventConverters, SecurityPoliciesApplicationServiceImpl securityPoliciesApplicationService, AlfrescoPagedModelAssembler<CloudRuntimeEvent<?, CloudRuntimeEventType>> pagedCollectionModelAssembler) {
        this.eventsRepository = eventsRepository;
        this.eventRepresentationModelAssembler = eventRepresentationModelAssembler;
        this.eventConverters = eventConverters;
        this.pagedCollectionModelAssembler = pagedCollectionModelAssembler;
        this.securityPoliciesApplicationService = securityPoliciesApplicationService;
    }

    @RequestMapping(value={"/{eventId}"}, method={RequestMethod.GET})
    public EntityModel<CloudRuntimeEvent<?, CloudRuntimeEventType>> findById(@PathVariable String eventId) {
        Optional findResult = this.eventsRepository.findByEventId(eventId);
        if (!findResult.isPresent()) {
            throw new NotFoundException("Unable to find event for the given id:'" + eventId + "'");
        }
        AuditEventEntity auditEventEntity = (AuditEventEntity)findResult.get();
        if (!this.securityPoliciesApplicationService.canRead(auditEventEntity.getProcessDefinitionId(), auditEventEntity.getServiceFullName())) {
            throw new ActivitiForbiddenException("Operation not permitted for " + auditEventEntity.getProcessDefinitionId());
        }
        CloudRuntimeEvent cloudRuntimeEvent = this.eventConverters.getConverterByEventTypeName(auditEventEntity.getEventType()).convertToAPI((Object)auditEventEntity);
        return this.eventRepresentationModelAssembler.toModel(cloudRuntimeEvent);
    }

    @RequestMapping(method={RequestMethod.GET})
    public PagedModel<EntityModel<CloudRuntimeEvent<?, CloudRuntimeEventType>>> search(SearchParams searchParams, Pageable pageable) {
        Specification<AuditEventEntity> spec = this.createSearchSpec(searchParams);
        spec = this.securityPoliciesApplicationService.createSpecWithSecurity(spec, SecurityPolicyAccess.READ);
        Page allAuditInPage = this.eventsRepository.findAll(spec, pageable);
        ArrayList<CloudRuntimeEvent> events = new ArrayList<CloudRuntimeEvent>();
        for (AuditEventEntity aee : allAuditInPage.getContent()) {
            EventToEntityConverter converterByEventTypeName = this.eventConverters.getConverterByEventTypeName(aee.getEventType());
            if (converterByEventTypeName != null) {
                events.add(converterByEventTypeName.convertToAPI((Object)aee));
                continue;
            }
            LOGGER.warn("Converter not found for Event Type: " + aee.getEventType());
        }
        return this.pagedCollectionModelAssembler.toModel(pageable, (Page)new PageImpl(events, pageable, allAuditInPage.getTotalElements()), (RepresentationModelAssembler)this.eventRepresentationModelAssembler);
    }

    private Specification<AuditEventEntity> createSearchSpec(SearchParams searchParams) {
        EventSpecificationsBuilder builder = new EventSpecificationsBuilder();
        String search = searchParams.search();
        if (search != null && !search.isEmpty()) {
            String operationSetExpr = Arrays.asList(SearchOperation.SIMPLE_OPERATION_SET).stream().collect(Collectors.joining("|"));
            Pattern pattern = Pattern.compile("(\\w+?)(" + operationSetExpr + ")(\\p{Punct}?)([a-zA-Z0-9-_]+?)(\\p{Punct}?),");
            Matcher matcher = pattern.matcher(search + ",");
            while (matcher.find()) {
                builder.with(matcher.group(1), matcher.group(2), (Object)matcher.group(4), matcher.group(3), matcher.group(5));
            }
        }
        if (searchParams.eventTimeFrom() != null) {
            builder.with("timestamp", ">=", (Object)searchParams.eventTimeFrom().getTime(), null, null);
        }
        if (searchParams.eventTimeTo() != null) {
            builder.with("timestamp", "<=", (Object)searchParams.eventTimeTo().getTime(), null, null);
        }
        return builder.build();
    }
}

