/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.controllers;

import java.util.ArrayList;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.services.audit.api.converters.APIEventToEntityConverters;
import org.activiti.cloud.services.audit.api.converters.CloudRuntimeEventType;
import org.activiti.cloud.services.audit.jpa.assembler.EventRepresentationModelAssembler;
import org.activiti.cloud.services.audit.jpa.events.AuditEventEntity;
import org.activiti.cloud.services.audit.jpa.repository.EventsRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@ConditionalOnProperty(name={"activiti.rest.enable-deletion"}, matchIfMissing=true)
@RestController
@RequestMapping(value={"/admin/v1/events"}, produces={"application/hal+json", "application/json"})
public class AuditEventsDeleteController {
    private final EventsRepository eventsRepository;
    private final EventRepresentationModelAssembler eventRepresentationModelAssembler;
    private final APIEventToEntityConverters eventConverters;

    @Autowired
    public AuditEventsDeleteController(EventsRepository eventsRepository, EventRepresentationModelAssembler eventRepresentationModelAssembler, APIEventToEntityConverters eventConverters) {
        this.eventsRepository = eventsRepository;
        this.eventRepresentationModelAssembler = eventRepresentationModelAssembler;
        this.eventConverters = eventConverters;
    }

    @RequestMapping(method={RequestMethod.DELETE})
    public CollectionModel<EntityModel<CloudRuntimeEvent<?, CloudRuntimeEventType>>> deleteEvents() {
        ArrayList result = new ArrayList();
        Iterable iterable = this.eventsRepository.findAll();
        for (AuditEventEntity entity : iterable) {
            result.add(this.eventRepresentationModelAssembler.toModel(this.eventConverters.getConverterByEventTypeName(entity.getEventType()).convertToAPI((Object)entity)));
        }
        this.eventsRepository.deleteAll(iterable);
        return CollectionModel.of(result);
    }
}

