/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.events;

import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import org.activiti.api.task.model.TaskCandidateUser;
import org.activiti.api.task.model.impl.TaskCandidateUserImpl;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.task.model.events.CloudTaskCandidateUserAddedEvent;
import org.activiti.cloud.services.audit.jpa.converters.json.TaskCandidateUserJpaJsonConverter;
import org.activiti.cloud.services.audit.jpa.events.AuditEventEntity;

@Entity(name="TaskCandidateUserAddedEvent")
@DiscriminatorValue(value="TaskCandidateUserAddedEvent")
public class TaskCandidateUserAddedEventEntity
extends AuditEventEntity {
    protected static final String TASK_CANDIDATE_USER_ADDED_EVENT = "TaskCandidateUserAddedEvent";
    @Convert(converter=TaskCandidateUserJpaJsonConverter.class)
    @Column(columnDefinition="text")
    private TaskCandidateUserImpl candidateUser;

    public TaskCandidateUserAddedEventEntity() {
    }

    public TaskCandidateUserAddedEventEntity(CloudTaskCandidateUserAddedEvent cloudEvent) {
        super((CloudRuntimeEvent<?, ?>)cloudEvent);
        this.setCandidateUser((TaskCandidateUser)cloudEvent.getEntity());
    }

    public TaskCandidateUser getCandidateUser() {
        return this.candidateUser;
    }

    public void setCandidateUser(TaskCandidateUser candidateUser) {
        this.candidateUser = new TaskCandidateUserImpl(candidateUser.getUserId(), candidateUser.getTaskId());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TaskCandidateUserAddedEventEntity [candidateUser=").append(this.candidateUser).append(", toString()=").append(super.toString()).append("]");
        return builder.toString();
    }
}

