/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.repository;

public enum SearchOperation {
    EQUALITY,
    NEGATION,
    GREATER_THAN,
    GREATER_THAN_EQUAL,
    LESS_THAN,
    LESS_THAN_EQUAL,
    LIKE,
    STARTS_WITH,
    ENDS_WITH,
    CONTAINS;

    public static final String[] SIMPLE_OPERATION_SET;
    public static final String OR_PREDICATE_FLAG = "'";
    public static final String ZERO_OR_MORE_REGEX = "*";
    public static final String OR_OPERATOR = "OR";
    public static final String AND_OPERATOR = "AND";
    public static final String LEFT_PARANTHESIS = "(";
    public static final String RIGHT_PARANTHESIS = ")";

    public static SearchOperation getSimpleOperation(String operation) {
        char input = operation.charAt(0);
        switch (input) {
            case ':': {
                return EQUALITY;
            }
            case '!': {
                return NEGATION;
            }
            case '>': {
                return operation.length() > 1 && operation.charAt(1) == '=' ? GREATER_THAN_EQUAL : GREATER_THAN;
            }
            case '<': {
                return operation.length() > 1 && operation.charAt(1) == '=' ? LESS_THAN_EQUAL : LESS_THAN;
            }
            case '~': {
                return LIKE;
            }
        }
        return null;
    }

    static {
        SIMPLE_OPERATION_SET = new String[]{":", "!", ">", "<", "~"};
    }
}

