/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.repository;

import java.util.ArrayList;
import java.util.List;
import org.activiti.cloud.services.audit.jpa.events.AuditEventEntity;
import org.activiti.cloud.services.audit.jpa.repository.EventSpecification;
import org.activiti.cloud.services.audit.jpa.repository.SearchOperation;
import org.activiti.cloud.services.audit.jpa.repository.SpecSearchCriteria;
import org.springframework.data.jpa.domain.Specification;

public class EventSpecificationsBuilder {
    private final List<SpecSearchCriteria> params = new ArrayList<SpecSearchCriteria>();

    public final EventSpecificationsBuilder with(String key, String operation, Object value, String prefix, String suffix) {
        return this.with(null, key, operation, value, prefix, suffix);
    }

    public final EventSpecificationsBuilder with(String orPredicate, String key, String operation, Object value, String prefix, String suffix) {
        SearchOperation op = SearchOperation.getSimpleOperation(operation);
        if (op != null) {
            if (op == SearchOperation.EQUALITY) {
                boolean endWithAsterisk;
                boolean startWithAsterisk = prefix != null && prefix.contains("*");
                boolean bl = endWithAsterisk = suffix != null && suffix.contains("*");
                if (startWithAsterisk && endWithAsterisk) {
                    op = SearchOperation.CONTAINS;
                } else if (startWithAsterisk) {
                    op = SearchOperation.ENDS_WITH;
                } else if (endWithAsterisk) {
                    op = SearchOperation.STARTS_WITH;
                }
            }
            this.params.add(new SpecSearchCriteria(orPredicate, key, op, value));
        }
        return this;
    }

    public Specification<AuditEventEntity> build() {
        if (this.params.size() == 0) {
            return null;
        }
        EventSpecification result = new EventSpecification(this.params.get(0));
        for (int i = 1; i < this.params.size(); ++i) {
            result = this.params.get(i).isOrPredicate() ? Specification.where((Specification)result).or((Specification)new EventSpecification(this.params.get(i))) : Specification.where((Specification)result).and((Specification)new EventSpecification(this.params.get(i)));
        }
        return result;
    }

    public final EventSpecificationsBuilder with(EventSpecification spec) {
        this.params.add(spec.getCriteria());
        return this;
    }

    public final EventSpecificationsBuilder with(SpecSearchCriteria criteria) {
        this.params.add(criteria);
        return this;
    }
}

