/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.events;

import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import org.activiti.api.process.model.MessageSubscription;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.process.model.events.CloudMessageSubscriptionCancelledEvent;
import org.activiti.cloud.services.audit.jpa.converters.json.MessageSubscriptionJpaJsonConverter;
import org.activiti.cloud.services.audit.jpa.events.AuditEventEntity;

@Entity
@DiscriminatorValue(value="MsgSubscriptionCancelledEvent")
public class MessageSubscriptionCancelledAuditEventEntity
extends AuditEventEntity {
    protected static final String MESSAGE_SUBSCRIPTION_CANCELLED_EVENT = "MsgSubscriptionCancelledEvent";
    @Convert(converter=MessageSubscriptionJpaJsonConverter.class)
    @Column(columnDefinition="text")
    private MessageSubscription messageSubscription;

    public MessageSubscriptionCancelledAuditEventEntity() {
    }

    public MessageSubscriptionCancelledAuditEventEntity(CloudMessageSubscriptionCancelledEvent cloudEvent) {
        super((CloudRuntimeEvent<?, ?>)cloudEvent);
        this.setMessageSubscription((MessageSubscription)cloudEvent.getEntity());
        if (this.messageSubscription != null) {
            this.setProcessDefinitionId(this.messageSubscription.getProcessDefinitionId());
            this.setProcessInstanceId(this.messageSubscription.getProcessInstanceId());
            this.setEntityId(this.messageSubscription.getId());
        }
    }

    public MessageSubscription getMessageSubscription() {
        return this.messageSubscription;
    }

    public void setMessageSubscription(MessageSubscription messageSubscription) {
        this.messageSubscription = messageSubscription;
    }
}

