/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.events;

import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.MappedSuperclass;
import org.activiti.api.process.model.BPMNTimer;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.process.model.events.CloudBPMNTimerEvent;
import org.activiti.cloud.services.audit.jpa.converters.json.TimerJpaJsonConverter;
import org.activiti.cloud.services.audit.jpa.events.AuditEventEntity;

@MappedSuperclass
public abstract class TimerAuditEventEntity
extends AuditEventEntity {
    @Convert(converter=TimerJpaJsonConverter.class)
    @Column(columnDefinition="text")
    private BPMNTimer timer;

    public TimerAuditEventEntity() {
    }

    public TimerAuditEventEntity(CloudBPMNTimerEvent cloudEvent) {
        super((CloudRuntimeEvent<?, ?>)cloudEvent);
        this.timer = (BPMNTimer)cloudEvent.getEntity();
        if (this.timer != null) {
            this.setProcessDefinitionId(this.timer.getProcessDefinitionId());
            this.setProcessInstanceId(this.timer.getProcessInstanceId());
        }
        if (this.timer != null) {
            this.setEntityId(this.timer.getElementId());
        }
    }

    public BPMNTimer getTimer() {
        return this.timer;
    }

    public void setTimer(BPMNTimer timer) {
        this.timer = timer;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TimerAuditEventEntity [timer=").append(this.timer).append(", toString()=").append(super.toString()).append("]");
        return builder.toString();
    }
}

