/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.events;

import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import org.activiti.api.process.model.Deployment;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.process.model.events.CloudApplicationDeployedEvent;
import org.activiti.cloud.services.audit.jpa.converters.json.ApplicationJpaJsonConverter;
import org.activiti.cloud.services.audit.jpa.events.AuditEventEntity;

@Entity(name="ApplicationDeployedEvent")
@DiscriminatorValue(value="ApplicationDeployedEvent")
public class ApplicationDeployedAuditEventEntity
extends AuditEventEntity {
    protected static final String APPLICATION_DEPLOYED_EVENT = "ApplicationDeployedEvent";
    @Convert(converter=ApplicationJpaJsonConverter.class)
    @Column(columnDefinition="text")
    private Deployment deployment;

    public ApplicationDeployedAuditEventEntity() {
    }

    public ApplicationDeployedAuditEventEntity(CloudApplicationDeployedEvent cloudEvent) {
        super((CloudRuntimeEvent<?, ?>)cloudEvent);
        this.setDeployment((Deployment)cloudEvent.getEntity());
    }

    public Deployment getDeployment() {
        return this.deployment;
    }

    public void setDeployment(Deployment deployment) {
        this.deployment = deployment;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ApplicationDeployedAuditEventEntity [deployment=").append(this.deployment).append(", toString()=").append(super.toString()).append("]");
        return builder.toString();
    }
}

