/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.events;

import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.MappedSuperclass;
import org.activiti.api.model.shared.model.VariableInstance;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.model.shared.events.CloudVariableEvent;
import org.activiti.cloud.services.audit.jpa.converters.json.VariableJpaJsonConverter;
import org.activiti.cloud.services.audit.jpa.events.AuditEventEntity;

@MappedSuperclass
public abstract class VariableAuditEventEntity
extends AuditEventEntity {
    private String variableName;
    private String variableType;
    private String taskId;
    private boolean ephemeralVariable;
    @Convert(converter=VariableJpaJsonConverter.class)
    @Column(columnDefinition="text")
    private VariableInstance variableInstance;

    public VariableAuditEventEntity() {
    }

    public VariableAuditEventEntity(CloudVariableEvent cloudEvent) {
        super((CloudRuntimeEvent<?, ?>)cloudEvent);
        this.setVariableInstance((VariableInstance)cloudEvent.getEntity());
        this.ephemeralVariable = cloudEvent.isEphemeralVariable();
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String getVariableType() {
        return this.variableType;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public void setVariableType(String variableType) {
        this.variableType = variableType;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public VariableInstance getVariableInstance() {
        return this.variableInstance;
    }

    public boolean isEphemeralVariable() {
        return this.ephemeralVariable;
    }

    public void setVariableInstance(VariableInstance variableInstance) {
        this.variableInstance = variableInstance;
        if (variableInstance != null) {
            this.variableName = variableInstance.getName();
            this.variableType = variableInstance.getType();
            this.taskId = variableInstance.getTaskId();
            this.setEntityId(variableInstance.getName());
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("VariableAuditEventEntity [variableName=").append(this.variableName).append(", variableType=").append(this.variableType).append(", taskId=").append(this.taskId).append(", variableInstance=").append(this.variableInstance).append(", toString()=").append(super.toString()).append("]");
        return builder.toString();
    }
}

